// Copyright (c) 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * A simple bypass node demo.
 *
 * @class BypassProcessor
 * @extends AudioWorkletProcessor
 */
class BypassProcessor extends AudioWorkletProcessor {
  // When constructor() undefined, the default constructor will be implicitly
  // used.

  static get parameterDescriptors() {
    return [{name: 'G', defaultValue: 0.2}];
  }

  constructor(options) {
    super(options);
  }

  process(inputs, outputs,     parameters  ) {
    // By default, the node has single input and output.


    const input = inputs[0];
    const output = outputs[0];


    for (let channel = 0; channel < output.length; ++channel) {
      output[channel].set(input[channel]);
    }

    console.log("BypassProcessor i", input)
    console.log("BypassProcessor o", output)
    console.log("BypassProcessor p", parameters)
    console.log("BypassProcessor p2", parameters['G'])
//    console.log(parameters.get('G').value); // 0.10000000149011612 in Chrome 77


    return true;
  }
}

registerProcessor('bypass-processor', BypassProcessor);
