/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.AudioFile;
import com.example.ctrl891.service.AudioPublisher;
import com.example.ctrl891.service.WavPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR \u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/example/ctrl891/service/WavPlayer;", "", "publisher", "Lcom/example/ctrl891/service/AudioPublisher;", "(Lcom/example/ctrl891/service/AudioPublisher;)V", "audioDirectory", "", "getAudioDirectory", "()Ljava/lang/String;", "dataPerSecond", "", "getDataPerSecond", "()I", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "logger", "Lmu/KLogger;", "getPublisher", "()Lcom/example/ctrl891/service/AudioPublisher;", "ratePerSecond", "getRatePerSecond", "waveFilePublishScheduler", "Ljava/util/concurrent/ScheduledFuture;", "getWaveFilePublishScheduler", "()Ljava/util/concurrent/ScheduledFuture;", "setWaveFilePublishScheduler", "(Ljava/util/concurrent/ScheduledFuture;)V", "feedTest", "", "isPlaying", "", "listWave", "", "Lcom/example/ctrl891/model/AudioFile;", "startPublishWaveFile", "filename", "stopPublishWaveFile", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nAudioService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioService.kt\ncom/example/ctrl891/service/WavPlayer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n3792#2:273\n4307#2,2:274\n1549#3:276\n1620#3,3:277\n*S KotlinDebug\n*F\n+ 1 AudioService.kt\ncom/example/ctrl891/service/WavPlayer\n*L\n267#1:273\n267#1:274,2\n267#1:276\n267#1:277,3\n*E\n"})
public final class WavPlayer {
    @NotNull
    private final AudioPublisher publisher;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String audioDirectory;
    private final int dataPerSecond;
    private final int ratePerSecond;
    private final ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<?> waveFilePublishScheduler;

    public WavPlayer(@NotNull AudioPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.publisher = publisher;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.audioDirectory = "audio";
        this.dataPerSecond = 88200;
        this.ratePerSecond = 10;
        this.executor = Executors.newScheduledThreadPool(1);
    }

    @NotNull
    public final AudioPublisher getPublisher() {
        return this.publisher;
    }

    @NotNull
    public final String getAudioDirectory() {
        return this.audioDirectory;
    }

    public final int getDataPerSecond() {
        return this.dataPerSecond;
    }

    public final int getRatePerSecond() {
        return this.ratePerSecond;
    }

    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Nullable
    public final ScheduledFuture<?> getWaveFilePublishScheduler() {
        return this.waveFilePublishScheduler;
    }

    public final void setWaveFilePublishScheduler(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.waveFilePublishScheduler = scheduledFuture;
    }

    public final void feedTest() {
        String filename = "output.wav";
        this.startPublishWaveFile(filename);
    }

    public final void startPublishWaveFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        byte[] data = FilesKt.readBytes((File)new File(this.audioDirectory, filename));
        int chunksize = this.dataPerSecond / this.ratePerSecond;
        List d = CollectionsKt.chunked((Iterable)ArraysKt.asList((byte[])data), (int)chunksize);
        int total = d.size();
        Ref.IntRef count = new Ref.IntRef();
        Iterator i = d.iterator();
        Runnable helloRunnable = () -> WavPlayer.startPublishWaveFile$lambda$0(i, this, count, total);
        this.waveFilePublishScheduler = this.executor.scheduleAtFixedRate(helloRunnable, 0L, (long)this.ratePerSecond * 10L, TimeUnit.MILLISECONDS);
        this.logger.info("scheduler started");
    }

    public final void stopPublishWaveFile() {
        if (this.waveFilePublishScheduler != null) {
            ScheduledFuture scheduledFuture = this.waveFilePublishScheduler;
            Intrinsics.checkNotNull((Object)scheduledFuture);
            scheduledFuture.cancel(false);
            this.waveFilePublishScheduler = null;
        }
    }

    public final boolean isPlaying() {
        return this.waveFilePublishScheduler != null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<AudioFile> listWave() {
        d = new File(this.audioDirectory);
        v0 = d.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"listFiles(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-WavPlayer$listWave$1 = false;
            if (!it.isFile()) ** GOTO lbl-1000
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)v1, (String)"wav", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (File)item$iv$iv;
            var12_15 = destination$iv$iv;
            $i$a$-map-WavPlayer$listWave$2 = false;
            v3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
            var12_15.add(new AudioFile(v3, it.length(), it.lastModified(), null));
        }
        return (List)destination$iv$iv;
    }

    private static final void startPublishWaveFile$lambda$0(Iterator $i, WavPlayer this$0, Ref.IntRef $count, int $total) {
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$count, (String)"$count");
        if ($i.hasNext()) {
            List el = (List)$i.next();
            int n = $count.element;
            $count.element = n + 1;
            this$0.logger.info("send " + el.size() + " (" + n + "/" + $total + ")");
            this$0.publisher.publish(CollectionsKt.toByteArray((Collection)el));
        } else {
            this$0.logger.info("no data");
            this$0.stopPublishWaveFile();
        }
    }
}

