/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.CAT_GENERIC_ERROR;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.PortInfo;
import com.example.ctrl891.service.CatCallback;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.SerialPortDataListener1;
import com.example.ctrl891.service.SerialService;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import jakarta.annotation.PreDestroy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020,H\u0017J\b\u0010-\u001a\u00020,H\u0016J\n\u0010.\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010/\u001a\u00020,H\u0016J\b\u00100\u001a\u00020\u000fH\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0017H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020205H\u0016J\u0010\u00106\u001a\u00020,2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\u00172\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0012J\u0018\u0010;\u001a\u00020,2\u0006\u0010:\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010<\u001a\u00020,2\u0006\u0010:\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020,2\u0006\u0010>\u001a\u00020\u000bH\u0016J\b\u0010@\u001a\u00020,H\u0016R\u0012\u0010\u0007\u001a\u00020\b8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u000f8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u001a\u0010$\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013\u00a8\u0006A"}, d2={"Lcom/example/ctrl891/service/SerialService;", "", "messageService", "Lcom/example/ctrl891/service/MessageService;", "coreService", "Lcom/example/ctrl891/service/CoreService;", "(Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/service/CoreService;)V", "baudrate", "", "blockingQueue", "Ljava/util/concurrent/BlockingQueue;", "", "getBlockingQueue", "()Ljava/util/concurrent/BlockingQueue;", "comPortNotConfiguredWarning", "", "getComPortNotConfiguredWarning", "()Z", "setComPortNotConfiguredWarning", "(Z)V", "getCoreService", "()Lcom/example/ctrl891/service/CoreService;", "currentComPort", "Lcom/fazecast/jSerialComm/SerialPort;", "getCurrentComPort", "()Lcom/fazecast/jSerialComm/SerialPort;", "setCurrentComPort", "(Lcom/fazecast/jSerialComm/SerialPort;)V", "log", "logger", "Lmu/KLogger;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "showProperties", "getShowProperties", "setShowProperties", "zeroByteDetected", "getZeroByteDetected", "setZeroByteDetected", "connect", "catCallback", "Lcom/example/ctrl891/service/CatCallback;", "attemptCount", "destroy", "", "disconnect", "getComPortName", "init", "isConnected", "listPortInfo", "Lcom/example/ctrl891/model/PortInfo;", "p", "listPorts", "", "portClosed", "portOpened", "comPort1", "readLoop", "comPort", "runPort", "runPortThread", "send", "t", "sendInternal", "start", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nSerialService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialService.kt\ncom/example/ctrl891/service/SerialService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n11065#2:380\n11400#2,3:381\n1045#3:384\n766#3:386\n857#3,2:387\n1855#3,2:389\n1#4:385\n*S KotlinDebug\n*F\n+ 1 SerialService.kt\ncom/example/ctrl891/service/SerialService\n*L\n104#1:380\n104#1:381,3\n113#1:384\n301#1:386\n301#1:387,2\n304#1:389,2\n*E\n"})
public class SerialService {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final KLogger logger;
    @Value(value="${serial.log:false}")
    private boolean log;
    @Value(value="${serial.baudrate:0}")
    private int baudrate;
    @Nullable
    private SerialPort currentComPort;
    @NotNull
    private final BlockingQueue<String> blockingQueue;
    private boolean comPortNotConfiguredWarning;
    private boolean showProperties;
    private boolean zeroByteDetected;

    public SerialService(@NotNull MessageService messageService, @NotNull CoreService coreService) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        this.messageService = messageService;
        this.coreService = coreService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.blockingQueue = new LinkedBlockingDeque();
        this.showProperties = true;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @Nullable
    public SerialPort getCurrentComPort() {
        return this.currentComPort;
    }

    public void setCurrentComPort(@Nullable SerialPort serialPort) {
        this.currentComPort = serialPort;
    }

    public boolean isConnected() {
        return this.getCurrentComPort() != null;
    }

    @Nullable
    public String getComPortName() {
        return this.getCoreService().getComPortName();
    }

    @NotNull
    public BlockingQueue<String> getBlockingQueue() {
        return this.blockingQueue;
    }

    public void init() {
        this.listPorts();
        this.start();
    }

    public void start() {
        this.logger.info("start send queue");
        this.logger.info("log debug = " + this.log);
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"SendQueue", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    @PreDestroy
    public void destroy() {
        this.logger.info("shutdown");
        this.disconnect();
    }

    public void disconnect() {
        SerialPort p = this.getCurrentComPort();
        if (p != null) {
            p.closePort();
            this.setCurrentComPort(null);
        }
    }

    public void send(@NotNull String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String t1 = ((Object)StringsKt.trim((CharSequence)t)).toString();
        this.getBlockingQueue().add(t1);
    }

    public void sendInternal(@NotNull String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this.getCurrentComPort() != null) {
            Object s;
            Object object = s = !StringsKt.endsWith$default((String)t, (String)";", (boolean)false, (int)2, null) ? t + ";" : t;
            if (this.log) {
                this.logger.info("CAT OUT " + (String)s);
            }
            Object object2 = s;
            byte[] byArray = ((String)object2).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] b = byArray;
            SerialPort serialPort = this.getCurrentComPort();
            Intrinsics.checkNotNull((Object)serialPort);
            serialPort.writeBytes(b, b.length);
        } else {
            this.logger.warn("com port not connected");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PortInfo> listPorts() {
        void $this$mapTo$iv$iv;
        this.logger.info("List all serial ports");
        SerialPort[] comPorts = SerialPort.getCommPorts();
        boolean count = false;
        Intrinsics.checkNotNull((Object)comPorts);
        SerialPort[] $this$map$iv = comPorts;
        boolean $i$f$map = false;
        SerialPort[] serialPortArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.listPortInfo((SerialPort)it));
        }
        List ports = (List)destination$iv$iv;
        if (ports.isEmpty()) {
            this.logger.warn("No serial ports found");
        }
        Iterable $this$sortedBy$iv = ports;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public PortInfo listPortInfo(@NotNull SerialPort p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.logger.info("name=" + p.getSystemPortName() + ", portDescription=" + p.getPortDescription() + " , systemPortPath=" + p.getSystemPortPath() + ", portLocation=" + p.getPortLocation() + ", descriptivePortName=" + p.getDescriptivePortName());
        String string = p.getSystemPortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPortName(...)");
        String string2 = p.getSystemPortPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSystemPortPath(...)");
        String string3 = p.getPortLocation();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPortLocation(...)");
        String string4 = p.getPortDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPortDescription(...)");
        String string5 = p.getDescriptivePortName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getDescriptivePortName(...)");
        return new PortInfo(string, string2, string3, string4, string5);
    }

    public boolean getComPortNotConfiguredWarning() {
        return this.comPortNotConfiguredWarning;
    }

    public void setComPortNotConfiguredWarning(boolean bl) {
        this.comPortNotConfiguredWarning = bl;
    }

    public boolean connect(@NotNull CatCallback catCallback, int attemptCount) {
        SerialPort comPort1;
        String pn;
        block8: {
            SerialPort serialPort;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)catCallback, (String)"catCallback");
                    pn = this.getComPortName();
                    if (pn == null) break block9;
                    String string = ((Object)StringsKt.trim((CharSequence)pn)).toString();
                    boolean bl = string != null ? string.length() == 0 : false;
                    if (!bl) break block10;
                }
                if (this.getComPortNotConfiguredWarning()) {
                    return false;
                }
                String text = "com port not configured";
                this.logger.warn(text);
                this.getMessageService().addCatMessage((CatCommand)new CAT_GENERIC_ERROR(null, text, 1, null));
                this.setComPortNotConfiguredWarning(true);
                return false;
            }
            this.setComPortNotConfiguredWarning(false);
            if (attemptCount == 0) {
                this.logger.info("connect to com port '" + pn + "'");
            }
            SerialPort[] comPorts = SerialPort.getCommPorts();
            Intrinsics.checkNotNull((Object)comPorts);
            SerialPort[] serialPortArray = comPorts;
            int n = serialPortArray.length;
            for (int i = 0; i < n; ++i) {
                SerialPort serialPort2;
                SerialPort it = serialPort2 = serialPortArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSystemPortName(), (Object)pn)) continue;
                serialPort = serialPort2;
                break block8;
            }
            serialPort = comPort1 = null;
        }
        if (comPort1 != null) {
            this.runPortThread(comPort1, catCallback);
            return true;
        }
        if (attemptCount % 10 == 0) {
            String text = "com port not found: " + pn;
            this.logger.warn(text);
            this.getMessageService().addCatMessage((CatCommand)new CAT_GENERIC_ERROR(null, text, 1, null));
        }
        return false;
    }

    public static /* synthetic */ boolean connect$default(SerialService serialService, CatCallback catCallback, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return serialService.connect(catCallback, n);
    }

    public void runPortThread(@NotNull SerialPort comPort, @NotNull CatCallback catCallback) {
        Intrinsics.checkNotNullParameter((Object)comPort, (String)"comPort");
        Intrinsics.checkNotNullParameter((Object)catCallback, (String)"catCallback");
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"SerialService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public void portOpened(@NotNull SerialPort comPort1, @NotNull CatCallback catCallback) {
        Intrinsics.checkNotNullParameter((Object)comPort1, (String)"comPort1");
        Intrinsics.checkNotNullParameter((Object)catCallback, (String)"catCallback");
        this.setCurrentComPort(comPort1);
        CatCallback.DefaultImpls.connectionState$default((CatCallback)catCallback, (boolean)true, (boolean)false, (int)2, null);
    }

    public void portClosed(@NotNull CatCallback catCallback) {
        Intrinsics.checkNotNullParameter((Object)catCallback, (String)"catCallback");
        this.setCurrentComPort(null);
        this.getMessageService().addCatMessage((CatCommand)new CAT_GENERIC_ERROR(null, "serial port disconnected", 1, null));
        CatCallback.DefaultImpls.connectionState$default((CatCallback)catCallback, (boolean)false, (boolean)false, (int)2, null);
    }

    public boolean getShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean bl) {
        this.showProperties = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPort(@NotNull SerialPort comPort, @NotNull CatCallback catCallback) {
        Intrinsics.checkNotNullParameter((Object)comPort, (String)"comPort");
        Intrinsics.checkNotNullParameter((Object)catCallback, (String)"catCallback");
        int newBaudRate = 38400;
        int newDataBits = 8;
        int newStopBits = 1;
        int newParity = 0;
        if (this.getShowProperties()) {
            this.logger.info("set com port properties");
            this.logger.info("BaudRate=" + newBaudRate);
            this.logger.info("DataBits=" + newDataBits);
            this.logger.info("StopBits=1");
            this.logger.info("Parity=0");
            this.logger.info("FlowControl=0");
            this.setShowProperties(false);
        }
        comPort.setComPortParameters(newBaudRate, newDataBits, newStopBits, newParity);
        comPort.setFlowControl(0);
        SerialPortDataListener1 listener = new SerialPortDataListener1();
        comPort.addDataListener((SerialPortDataListener)listener);
        boolean co = comPort.openPort();
        if (co) {
            this.portOpened(comPort, catCallback);
            try {
                this.readLoop(comPort, catCallback);
            }
            catch (Exception e) {
                this.logger.info("Port error", (Throwable)e);
            }
            finally {
                comPort.closePort();
                comPort.removeDataListener();
                this.portClosed(catCallback);
            }
        } else {
            this.logger.error("Could not open port");
        }
    }

    public boolean getZeroByteDetected() {
        return this.zeroByteDetected;
    }

    public void setZeroByteDetected(boolean bl) {
        this.zeroByteDetected = bl;
    }

    /*
     * WARNING - void declaration
     */
    private void readLoop(SerialPort comPort, CatCallback catCallback) {
        while (true) {
            void $this$filterTo$iv$iv;
            if (comPort.bytesAvailable() == 0) {
                Thread.sleep(20L);
                continue;
            }
            int bc = comPort.bytesAvailable();
            if (comPort.bytesAvailable() == -1) {
                if (!this.log) break;
                this.logger.info("Port was closed");
                break;
            }
            byte[] readBuffer = new byte[bc];
            int numRead = comPort.readBytes(readBuffer, readBuffer.length);
            if (numRead == 1) {
                // empty if block
            }
            if (numRead == 1 && readBuffer[0] == 0) {
                CatCallback catCallback2 = catCallback;
                if (catCallback2 != null) {
                    CatCallback.DefaultImpls.connectionState$default((CatCallback)catCallback2, (boolean)false, (boolean)false, (int)2, null);
                }
                continue;
            }
            if (readBuffer[0] == 0) continue;
            byte[] byArray = readBuffer;
            String[] stringArray = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"defaultCharset(...)");
            String[] stringArray2 = stringArray;
            String s = new String(byArray, (Charset)stringArray2);
            stringArray2 = new String[]{";"};
            List d = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)s)).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            Iterable $this$filter$iv = d;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(it.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List x = (List)destination$iv$iv;
            try {
                Iterable $this$forEach$iv = x;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)"RM", (boolean)false, (int)2, null) || !this.log) continue;
                    this.logger.debug("<<<< '" + it + "'");
                }
                if (x.size() <= 0) continue;
                CatCallback catCallback3 = catCallback;
                if (catCallback3 != null) {
                    catCallback3.processCatIn(x);
                }
            }
            catch (Exception ex) {
                this.logger.error("CAT error", (Throwable)ex);
            }
        }
    }

    static /* synthetic */ void readLoop$default(SerialService serialService, SerialPort serialPort, CatCallback catCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readLoop");
        }
        if ((n & 2) != 0) {
            catCallback = null;
        }
        serialService.readLoop(serialPort, catCallback);
    }
}

