/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.CAT_RIGCTL;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.IF;
import com.example.ctrl891.model.MODE_EX;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.CatStore;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.RigctlService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010.\u001a\u00020\tH\u0016J\b\u00109\u001a\u000206H\u0016J\u0018\u0010:\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u000206H\u0016J\u0010\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020\tH\u0016J\b\u0010@\u001a\u000206H\u0016J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020\u000fH\u0016J\b\u0010C\u001a\u000206H\u0016J\u0010\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u001aH\u0016J\u0010\u0010F\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0010\u0010G\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\b\u0010H\u001a\u000206H\u0016J\u0010\u0010I\u001a\u0002062\u0006\u0010J\u001a\u00020KH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\t8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\t8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u0004\u0018\u00010\t8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR\u001a\u0010(\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0012\u0010.\u001a\u0004\u0018\u00010\t8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001b\"\u0004\b1\u0010\u001dR\u001a\u00102\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001b\"\u0004\b4\u0010\u001d\u00a8\u0006L"}, d2={"Lcom/example/ctrl891/service/RigctlService;", "", "messageService", "Lcom/example/ctrl891/service/MessageService;", "catStore", "Lcom/example/ctrl891/service/CatStore;", "(Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/service/CatStore;)V", "blockingQueue", "Ljava/util/concurrent/BlockingQueue;", "", "getBlockingQueue", "()Ljava/util/concurrent/BlockingQueue;", "getCatStore", "()Lcom/example/ctrl891/service/CatStore;", "freq1", "", "getFreq1", "()I", "setFreq1", "(I)V", "ip", "getIp", "()Ljava/lang/String;", "ip2", "getIp2", "isConnected", "", "()Z", "setConnected", "(Z)V", "isStarted", "setStarted", "logger", "Lmu/KLogger;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "poll_interval", "pollingEnabledFlag", "getPollingEnabledFlag", "setPollingEnabledFlag", "pollingSleepTime", "", "getPollingSleepTime", "()J", "setPollingSleepTime", "(J)V", "port", "stopRequested", "getStopRequested", "setStopRequested", "syncEnabled", "getSyncEnabled", "setSyncEnabled", "connectAndProcess", "", "catService", "Lcom/example/ctrl891/service/CatService;", "processPolling", "processReader", "inp", "Ljava/io/BufferedReader;", "queryFreq", "send", "t", "sendCurrentFreq", "sendFreq", "f", "sendState", "setPollingEnabled", "p", "start", "startClient", "stop", "updateMode", "it", "Lcom/example/ctrl891/model/MODE_EX;", "ctrl891"})
public class RigctlService {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final CatStore catStore;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final BlockingQueue<String> blockingQueue;
    private boolean isConnected;
    private boolean isStarted;
    @Value(value="${rigctl.ip:localhost}")
    @Nullable
    private final String ip;
    @Value(value="${rigctl.ip2:localhost}")
    @Nullable
    private final String ip2;
    @Value(value="${rigctl.port:4532}")
    @Nullable
    private final String port;
    @Value(value="${rigctl.poll_interval:1}")
    @Nullable
    private final String poll_interval;
    private boolean pollingEnabledFlag;
    private long pollingSleepTime;
    private boolean syncEnabled;
    private int freq1;
    private boolean stopRequested;

    public RigctlService(@NotNull MessageService messageService, @NotNull CatStore catStore) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)catStore, (String)"catStore");
        this.messageService = messageService;
        this.catStore = catStore;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.blockingQueue = new LinkedBlockingDeque();
        this.pollingEnabledFlag = true;
        this.pollingSleepTime = 1000L;
        this.syncEnabled = true;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public CatStore getCatStore() {
        return this.catStore;
    }

    @NotNull
    public BlockingQueue<String> getBlockingQueue() {
        return this.blockingQueue;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean bl) {
        this.isStarted = bl;
    }

    @Nullable
    public String getIp() {
        return this.ip;
    }

    @Nullable
    public String getIp2() {
        return this.ip2;
    }

    public boolean getPollingEnabledFlag() {
        return this.pollingEnabledFlag;
    }

    public void setPollingEnabledFlag(boolean bl) {
        this.pollingEnabledFlag = bl;
    }

    public long getPollingSleepTime() {
        return this.pollingSleepTime;
    }

    public void setPollingSleepTime(long l) {
        this.pollingSleepTime = l;
    }

    public boolean getSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean bl) {
        this.syncEnabled = bl;
    }

    public void start(@NotNull CatService catService) {
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        if (this.getIp() == null) {
            return;
        }
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"RigctlService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public int getFreq1() {
        return this.freq1;
    }

    public void setFreq1(int n) {
        this.freq1 = n;
    }

    public void startClient(@NotNull CatService catService) {
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        while (true) {
            String string = this.getIp();
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.port;
            Intrinsics.checkNotNull((Object)string2);
            this.connectAndProcess(catService, string, string2);
            String string3 = this.getIp2();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = this.port;
            Intrinsics.checkNotNull((Object)string4);
            this.connectAndProcess(catService, string3, string4);
        }
    }

    public boolean getStopRequested() {
        return this.stopRequested;
    }

    public void setStopRequested(boolean bl) {
        this.stopRequested = bl;
    }

    public void connectAndProcess(@NotNull CatService catService, @NotNull String ip, @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        try {
            int n;
            int p = 4532;
            try {
                p = Integer.parseInt(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Socket clientSocket = new Socket(ip, p);
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            BufferedReader inp = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            this.setConnected(true);
            boolean bl = this.getPollingEnabledFlag();
            boolean bl2 = this.getSyncEnabled();
            this.getMessageService().addCatMessage((CatCommand)new CAT_RIGCTL(null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(bl), Boolean.valueOf(bl2), 1, null));
            this.logger.info("connected to " + ip);
            Thread readerThread2 = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"RigctlReaderService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
            long pollingStartDelayTime = 5000L;
            try {
                String string = this.poll_interval;
                n = string != null ? Integer.parseInt(string) : 0;
            }
            catch (Exception e) {
                n = 0;
            }
            int poll_interval_parsed = n;
            this.setPollingEnabledFlag(poll_interval_parsed != 0);
            this.setPollingSleepTime(this.getPollingEnabledFlag() ? (long)poll_interval_parsed * 1000L : 10000L);
            Thread pollingThread2 = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"RigctlPollingService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
            long writerStartDelayTime = 5000L;
            Thread writerThread2 = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"RigctlWriterService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
            CatCommand d1 = this.getCatStore().get("INFORMATION");
            if (d1 instanceof IF) {
                int f2 = ((IF)d1).getFreq();
                this.sendFreq(f2);
            }
            MODE_EX m = CatStore.determineModeWithSideband$default((CatStore)this.getCatStore(), (boolean)false, (int)1, null);
            this.updateMode(m);
            while (!this.getStopRequested()) {
                Thread.sleep(1000L);
            }
            try {
                pollingThread2.interrupt();
                readerThread2.interrupt();
                writerThread2.interrupt();
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getMessageService().addCatMessage((CatCommand)new CAT_RIGCTL(null, Boolean.valueOf(false), Boolean.valueOf(true), null, null, 25, null));
        this.setConnected(false);
        this.setStopRequested(false);
        Thread.sleep(5000L);
    }

    public void processReader(@NotNull CatService catService, @NotNull BufferedReader inp) {
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        String inputLine = null;
        try {
            while (!this.getStopRequested() && (inputLine = inp.readLine()) != null) {
                if (inputLine.equals("RPRT 1")) {
                    this.logger.info("rigctl error: " + inputLine);
                    continue;
                }
                if (inputLine.equals("RPRT 0")) continue;
                try {
                    int i = Integer.parseInt(inputLine);
                    if (i <= 0 || !this.getSyncEnabled()) continue;
                    CatService.setFreq$default((CatService)catService, (int)i, (boolean)false, (int)2, null);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.warn("reader end");
        this.setStopRequested(true);
    }

    public void processPolling() {
        while (!this.getStopRequested()) {
            if (this.getPollingEnabledFlag()) {
                this.queryFreq();
            }
            Thread.sleep(this.getPollingSleepTime());
        }
    }

    public void stop() {
    }

    public void setPollingEnabled(boolean p) {
        this.setPollingEnabledFlag(p);
    }

    public void sendCurrentFreq() {
        Integer f2;
        if (this.getSyncEnabled() && (f2 = CatStore.getFreq$default((CatStore)this.getCatStore(), (boolean)false, (int)1, null)) != null) {
            this.send("F " + f2);
        }
    }

    public void sendFreq(int f2) {
        if (this.getSyncEnabled()) {
            this.send("F " + f2);
        }
    }

    public void queryFreq() {
        this.send("f");
    }

    public void send(@NotNull String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String t1 = ((Object)StringsKt.trim((CharSequence)t)).toString();
        if (this.isConnected()) {
            this.getBlockingQueue().add(t1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateMode(@NotNull MODE_EX it) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            var4_3 = mode = it.getLabel();
            switch (var4_3.hashCode()) {
                case 2164: {
                    if (!var4_3.equals("CW")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 84324: {
                    if (!var4_3.equals("USB")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 2247: {
                    if (!var4_3.equals("FM")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 75675: {
                    if (!var4_3.equals("LSB")) {
                        break;
                    }
                    ** GOTO lbl22
                }
                case 2092: {
                    if (!var4_3.equals("AM")) break;
lbl22:
                    // 5 sources

                    v0 = mode;
                    break block11;
                }
            }
            v0 = it.getSideband();
        }
        m = v0;
        bw = 0;
        cmd = "M " + m + " " + bw;
        this.send(cmd);
    }

    public void sendState() {
        boolean bl = this.getPollingEnabledFlag();
        boolean bl2 = this.getSyncEnabled();
        this.getMessageService().addCatMessage((CatCommand)new CAT_RIGCTL(null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(bl), Boolean.valueOf(bl2), 1, null));
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RigctlService $this) {
        return $this.logger;
    }
}

