/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.CAT_DXCLUSTER;
import com.example.ctrl891.model.CAT_GENERIC_ERROR;
import com.example.ctrl891.model.CAT_GENERIC_MESSAGE;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.Message;
import com.example.ctrl891.model.MessageVM;
import com.example.ctrl891.service.MessageRepository;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/example/ctrl891/service/MessageRepository;", "", "()V", "data", "", "", "Lcom/example/ctrl891/model/Message;", "getData", "()Ljava/util/Map;", "logger", "Lmu/KLogger;", "add", "", "m", "findLatest", "Lkotlinx/coroutines/flow/Flow;", "Lcom/example/ctrl891/model/MessageVM;", "id", "loadState", "saveState", "simple", "", "simple2", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nMessageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageRepository.kt\ncom/example/ctrl891/service/MessageRepository\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,146:1\n215#2,2:147\n215#2,2:152\n113#3:149\n113#3:150\n96#4:151\n*S KotlinDebug\n*F\n+ 1 MessageRepository.kt\ncom/example/ctrl891/service/MessageRepository\n*L\n35#1:147,2\n128#1:152,2\n110#1:149\n118#1:150\n124#1:151\n*E\n"})
public class MessageRepository {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final Map<String, Message> data = new LinkedHashMap();

    @NotNull
    public Map<String, Message> getData() {
        return this.data;
    }

    @NotNull
    public Flow<Message> findLatest() {
        Map $this$forEach$iv = this.getData();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.logger.debug("send message " + it.getKey() + " -> " + ((Message)it.getValue()).getCat());
        }
        List d = CollectionsKt.toMutableList(this.getData().values());
        return FlowKt.flow((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Flow<MessageVM> findLatest(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger.info("findLatest2 " + id);
        return FlowKt.flow((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void add(@NotNull Message m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        CatCommand cat = m.getCat();
        if (cat == null) {
            this.logger.warn("empty cat " + m);
        } else if (!(Intrinsics.areEqual((Object)cat.getCmd(), (Object)"UnknownCatCmd") || cat instanceof CAT_DXCLUSTER && ((CAT_DXCLUSTER)cat).getEntry() != null || cat instanceof CAT_GENERIC_MESSAGE || cat instanceof CAT_GENERIC_ERROR)) {
            this.getData().put(cat.getCmd(), m);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveState() {
        void $this$encodeToString$iv;
        StringFormat stringFormat = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)saveState.json.1.INSTANCE), (int)1, null);
        Map value$iv = this.getData();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, Message.Companion.serializer()), (Object)value$iv);
        String path = "state.json";
        File file = new File(path);
        this.logger.info("write state json " + file.getAbsolutePath());
        FilesKt.writeText$default((File)file, (String)json2, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void loadState() {
        void $this$encodeToString$iv;
        StringFormat stringFormat = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)loadState.json.1.INSTANCE), (int)1, null);
        Map value$iv = this.getData();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, Message.Companion.serializer()), (Object)value$iv);
        String path = "state.json";
        File file = new File(path);
        this.logger.info("read state json " + file.getAbsolutePath());
        String text = FilesKt.readText$default((File)file, null, (int)1, null);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Map deserialized = (Map)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, Message.Companion.serializer()), text);
        this.logger.info("read state json elements" + deserialized.size());
        this.getData().clear();
        Map $this$forEach$iv = deserialized;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry x = element$iv = iterator.next();
            boolean bl = false;
            this.getData().put(x.getKey(), x.getValue());
        }
    }

    @NotNull
    public Flow<Integer> simple() {
        return FlowKt.flow((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Flow<Message> simple2() {
        return FlowKt.flow((Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }
}

