/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.LogEntry;
import com.example.ctrl891.model.Logbook;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.LogService;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:H\u0012J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020&H\u0016J\b\u0010=\u001a\u00020\u000eH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0012J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020?H\u0016J\u0018\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000eH\u0012J\u0010\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020:H\u0016J\u0018\u0010J\u001a\u00020?2\u0006\u0010K\u001a\u00020C2\u0006\u0010L\u001a\u00020AH\u0016J\u0010\u0010M\u001a\u00020?2\u0006\u0010I\u001a\u00020:H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010.R\u001c\u00103\u001a\n 5*\u0004\u0018\u00010404X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006N"}, d2={"Lcom/example/ctrl891/service/LogService;", "", "coreService", "Lcom/example/ctrl891/service/CoreService;", "(Lcom/example/ctrl891/service/CoreService;)V", "connected", "", "getConnected", "()Z", "setConnected", "(Z)V", "getCoreService", "()Lcom/example/ctrl891/service/CoreService;", "dir", "", "getDir", "()Ljava/lang/String;", "eor", "getEor", "filename_adi", "getFilename_adi", "filename_json", "getFilename_json", "hourInMs", "", "getHourInMs", "()F", "lf", "getLf", "logger", "Lmu/KLogger;", "power", "", "getPower", "()I", "setPower", "(I)V", "sleepTime", "", "getSleepTime", "()J", "sp", "getSp", "utcFormatterDate", "Ljava/time/format/DateTimeFormatter;", "getUtcFormatterDate", "()Ljava/time/format/DateTimeFormatter;", "utcFormatterDateTime", "getUtcFormatterDateTime", "utcFormatterTime", "getUtcFormatterTime", "utcZone", "Ljava/time/ZoneId;", "kotlin.jvm.PlatformType", "getUtcZone", "()Ljava/time/ZoneId;", "createEntry", "l", "Lcom/example/ctrl891/model/LogEntry;", "formatTime", "s", "getLogbookAdi", "initFile", "", "f", "Ljava/io/File;", "readCurrentJson", "Lcom/example/ctrl891/model/Logbook;", "start", "tag", "name", "content", "updateJson", "entry", "writeJson", "loogbook", "file", "writeLog", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nLogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogService.kt\ncom/example/ctrl891/service/LogService\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,180:1\n113#2:181\n113#2:183\n96#3:182\n*S KotlinDebug\n*F\n+ 1 LogService.kt\ncom/example/ctrl891/service/LogService\n*L\n99#1:181\n172#1:183\n118#1:182\n*E\n"})
public class LogService {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String dir;
    @NotNull
    private final String filename_adi;
    @NotNull
    private final String filename_json;
    private final ZoneId utcZone;
    @NotNull
    private final DateTimeFormatter utcFormatterDateTime;
    @NotNull
    private final DateTimeFormatter utcFormatterDate;
    @NotNull
    private final DateTimeFormatter utcFormatterTime;
    private final float hourInMs;
    private boolean connected;
    private int power;
    private final long sleepTime;
    @NotNull
    private final String lf;
    @NotNull
    private final String sp;
    @NotNull
    private final String eor;

    public LogService(@NotNull CoreService coreService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        this.coreService = coreService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.dir = "logbook";
        this.filename_adi = "logbook.adi";
        this.filename_json = "logbook.json";
        this.utcZone = ZoneId.of("UTC");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd HHmmss").withZone(this.getUtcZone());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        this.utcFormatterDateTime = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(this.getUtcZone());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"withZone(...)");
        this.utcFormatterDate = dateTimeFormatter2;
        DateTimeFormatter dateTimeFormatter3 = DateTimeFormatter.ofPattern("HHmm").withZone(this.getUtcZone());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter3, (String)"withZone(...)");
        this.utcFormatterTime = dateTimeFormatter3;
        this.hourInMs = 3600000.0f;
        this.power = 5;
        this.sleepTime = 10000L;
        this.lf = "\r\n";
        this.sp = " ";
        this.eor = "<eor>";
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @NotNull
    public String getDir() {
        return this.dir;
    }

    @NotNull
    public String getFilename_adi() {
        return this.filename_adi;
    }

    @NotNull
    public String getFilename_json() {
        return this.filename_json;
    }

    public ZoneId getUtcZone() {
        return this.utcZone;
    }

    @NotNull
    public DateTimeFormatter getUtcFormatterDateTime() {
        return this.utcFormatterDateTime;
    }

    @NotNull
    public DateTimeFormatter getUtcFormatterDate() {
        return this.utcFormatterDate;
    }

    @NotNull
    public DateTimeFormatter getUtcFormatterTime() {
        return this.utcFormatterTime;
    }

    public float getHourInMs() {
        return this.hourInMs;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int n) {
        this.power = n;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void start() {
    }

    @NotNull
    public String formatTime(long s) {
        String string = "%d:%02d";
        Object[] objectArray = new Object[]{s / (long)3600, s % (long)3600 / (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public void writeLog(@NotNull LogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        try {
            File file_adi;
            File d = new File(this.getDir());
            if (!d.exists()) {
                d.mkdirs();
            }
            if (!(file_adi = new File(d, this.getFilename_adi())).exists()) {
                this.logger.info("create new log file: " + file_adi);
                this.initFile(file_adi);
            }
            FilesKt.appendText$default((File)file_adi, (String)this.createEntry(entry), null, (int)2, null);
            this.updateJson(entry);
        }
        catch (Exception e) {
            this.logger.error("logbook write error", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public String getLogbookAdi() {
        File file_adi;
        File d = new File(this.getDir());
        if (!d.exists()) {
            d.mkdirs();
        }
        if (!(file_adi = new File(d, this.getFilename_adi())).exists()) {
            this.logger.info("create new log file: " + file_adi);
            this.initFile(file_adi);
        }
        return FilesKt.readText$default((File)file_adi, null, (int)1, null);
    }

    public void updateJson(@NotNull LogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Logbook logbook2 = this.readCurrentJson();
        Logbook nl = Logbook.copy$default((Logbook)logbook2, (long)0L, (List)CollectionsKt.plus((Collection)logbook2.getEntries(), (Object)entry), (int)1, null);
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)updateJson.json.1.INSTANCE), (int)1, null);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)Logbook.Companion.serializer(), (Object)nl);
        File d = new File(this.getDir());
        File file_json = new File(d, this.getFilename_json());
        FilesKt.writeText$default((File)file_json, (String)json2, null, (int)2, null);
    }

    @NotNull
    public Logbook readCurrentJson() {
        File file_json;
        File d = new File(this.getDir());
        if (!d.exists()) {
            d.mkdirs();
        }
        if (!(file_json = new File(d, this.getFilename_json())).exists()) {
            this.writeJson(new Logbook(System.currentTimeMillis(), CollectionsKt.emptyList()), file_json);
        }
        String text = FilesKt.readText$default((File)file_json, null, (int)1, null);
        Json this_$iv = JsonKt.Json$default(null, (Function1)((Function1)readCurrentJson.logbook.1.INSTANCE), (int)1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Logbook logbook2 = (Logbook)this_$iv.decodeFromString((DeserializationStrategy)Logbook.Companion.serializer(), text);
        return logbook2;
    }

    private String createEntry(LogEntry l) {
        Instant i = new Date(l.getTimestamp()).toInstant();
        String date = this.getUtcFormatterDate().format(i);
        String time = this.getUtcFormatterTime().format(i);
        String f2 = String.valueOf(Double.parseDouble(l.getFreq()) / (double)1000000);
        String string = this.tag("call", l.getCall());
        String string2 = this.getSp();
        String string3 = this.tag("mode", l.getMode());
        String string4 = this.getSp();
        Intrinsics.checkNotNull((Object)date);
        String string5 = this.tag("qso_date", date);
        String string6 = this.getSp();
        Intrinsics.checkNotNull((Object)time);
        String text = string + string2 + string3 + string4 + string5 + string6 + this.tag("time_on", time) + this.getSp() + this.tag("rst_sent", l.getRst_sent()) + this.getSp() + this.tag("rst_rcvd", l.getRst_rcvd()) + this.getSp() + this.tag("band", l.getBand()) + this.getSp() + this.tag("freq", f2) + this.getSp() + this.tag("comment", l.getComment()) + this.getSp() + this.tag("name", l.getName()) + this.getSp() + this.tag("tx_pwr", l.getTx_pwr()) + this.getSp() + this.getEor() + this.getLf();
        return text;
    }

    @NotNull
    public String getLf() {
        return this.lf;
    }

    @NotNull
    public String getSp() {
        return this.sp;
    }

    @NotNull
    public String getEor() {
        return this.eor;
    }

    private void initFile(File f2) {
        Date time = new Date();
        String ts = this.getUtcFormatterDateTime().format(time.toInstant());
        String string = this.getLf();
        String string2 = this.tag("adif_ver", "3.1.1");
        String string3 = this.getLf();
        Intrinsics.checkNotNull((Object)ts);
        String text = "ADIF Export" + string + string2 + string3 + this.tag("created_timestamp", ts) + this.getLf() + this.tag("programid", "891ctrl") + this.getLf() + this.tag("programversion", this.getCoreService().getBuildNr()) + this.getLf() + "<eoh>" + this.getLf();
        FilesKt.writeText$default((File)f2, (String)text, null, (int)2, null);
    }

    private String tag(String name, String content) {
        return "<" + name + ":" + content.length() + ">" + content;
    }

    public void writeJson(@NotNull Logbook loogbook, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)loogbook, (String)"loogbook");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)writeJson.json.1.INSTANCE), (int)1, null);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)Logbook.Companion.serializer(), (Object)loogbook);
        FilesKt.writeText$default((File)file, (String)json2, null, (int)2, null);
    }
}

