/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.generator.MenuService;
import com.example.ctrl891.model.CAT_MENU_LOAD_PROGRESS;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.model.KeyValue;
import com.example.ctrl891.model.MenuEntry;
import com.example.ctrl891.model.NominalEntry;
import com.example.ctrl891.model.RangeEntry;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.ExportService;
import com.example.ctrl891.service.MessageService;
import com.github.doyaaaaaken.kotlincsv.client.CsvReader;
import com.github.doyaaaaaken.kotlincsv.client.CsvWriter;
import com.github.doyaaaaaken.kotlincsv.dsl.CsvReaderDslKt;
import com.github.doyaaaaaken.kotlincsv.dsl.CsvWriterDslKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020)0\u0014H\u0016J\b\u00100\u001a\u00020.H\u0016J\u0018\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001cH\u0016J\u0010\u00104\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\bH\u0016J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\fH\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%RT\u0010&\u001aB\u0012\f\u0012\n (*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n (*\u0004\u0018\u00010)0) (* \u0012\f\u0012\n (*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n (*\u0004\u0018\u00010)0)\u0018\u00010*0'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006<"}, d2={"Lcom/example/ctrl891/service/ExportService;", "", "messageService", "Lcom/example/ctrl891/service/MessageService;", "menuService", "Lcom/example/ctrl891/generator/MenuService;", "(Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/generator/MenuService;)V", "MENU_PREFIX", "", "getMENU_PREFIX", "()Ljava/lang/String;", "catService", "Lcom/example/ctrl891/service/CatService;", "getCatService", "()Lcom/example/ctrl891/service/CatService;", "setCatService", "(Lcom/example/ctrl891/service/CatService;)V", "dir", "getDir", "hcutFilters", "", "getHcutFilters", "()Ljava/util/List;", "hcutOffset", "", "getHcutOffset", "()I", "isExportCompleted", "", "()Z", "setExportCompleted", "(Z)V", "logger", "Lmu/KLogger;", "getMenuService", "()Lcom/example/ctrl891/generator/MenuService;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "state", "", "kotlin.jvm.PlatformType", "Lcom/example/ctrl891/model/CatCommand;", "", "getState", "()Ljava/util/Map;", "add", "", "x", "clear", "export", "changed_only", "include_title", "getEntryDefault", "e", "Lcom/example/ctrl891/model/MenuEntry;", "import", "name", "init", "catService1", "list", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportService.kt\ncom/example/ctrl891/service/ExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1855#2,2:242\n1603#2,9:245\n1855#2:254\n1856#2:256\n1612#2:257\n1549#2:258\n1620#2,3:259\n1549#2:262\n1620#2,3:263\n766#2:266\n857#2,2:267\n766#2:269\n857#2,2:270\n766#2:272\n857#2,2:273\n766#2:275\n857#2,2:276\n1855#2,2:278\n1#3:244\n1#3:255\n*S KotlinDebug\n*F\n+ 1 ExportService.kt\ncom/example/ctrl891/service/ExportService\n*L\n53#1:242,2\n114#1:245,9\n114#1:254\n114#1:256\n114#1:257\n168#1:258\n168#1:259,3\n198#1:262\n198#1:263,3\n203#1:266\n203#1:267,2\n204#1:269\n204#1:270,2\n205#1:272\n205#1:273,2\n206#1:275\n206#1:276,2\n216#1:278,2\n114#1:255\n*E\n"})
public class ExportService {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final MenuService menuService;
    @NotNull
    private final KLogger logger;
    @Nullable
    private CatService catService;
    private final Map<String, CatCommand> state;
    private boolean isExportCompleted;
    @NotNull
    private final String dir;
    @NotNull
    private final String MENU_PREFIX;
    @NotNull
    private final List<String> hcutFilters;
    private final int hcutOffset;

    public ExportService(@NotNull MessageService messageService, @NotNull MenuService menuService) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)menuService, (String)"menuService");
        this.messageService = messageService;
        this.menuService = menuService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.state = Collections.synchronizedMap(new LinkedHashMap());
        this.dir = "menu-export";
        this.MENU_PREFIX = "EX";
        Object[] objectArray = new String[]{"0603", "0703", "0807", "1003", "1103"};
        this.hcutFilters = CollectionsKt.listOf((Object[])objectArray);
        this.hcutOffset = 600;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public MenuService getMenuService() {
        return this.menuService;
    }

    @Nullable
    public CatService getCatService() {
        return this.catService;
    }

    public void setCatService(@Nullable CatService catService) {
        this.catService = catService;
    }

    public void init(@NotNull CatService catService1) {
        Intrinsics.checkNotNullParameter((Object)catService1, (String)"catService1");
        this.setCatService(catService1);
    }

    public Map<String, CatCommand> getState() {
        return this.state;
    }

    public boolean isExportCompleted() {
        return this.isExportCompleted;
    }

    public void setExportCompleted(boolean bl) {
        this.isExportCompleted = bl;
    }

    public void clear() {
        this.getState().clear();
        this.setExportCompleted(false);
    }

    public void add(@NotNull List<? extends CatCommand> x) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Iterable $this$forEach$iv = x;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CatCommand it = (CatCommand)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it.getCmd(), (String)"EX", (boolean)false, (int)2, null)) continue;
            this.getState().put(it.getCmd(), it);
        }
    }

    @NotNull
    public String getDir() {
        return this.dir;
    }

    @NotNull
    public String getMENU_PREFIX() {
        return this.MENU_PREFIX;
    }

    @NotNull
    public List<String> getHcutFilters() {
        return this.hcutFilters;
    }

    public int getHcutOffset() {
        return this.hcutOffset;
    }

    @NotNull
    public String getEntryDefault(@NotNull MenuEntry e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MenuEntry menuEntry = e;
        if (menuEntry instanceof NominalEntry) {
            Object v0;
            block11: {
                Iterable iterable = ((NominalEntry)e).getValues();
                for (Object t : iterable) {
                    KeyValue it = (KeyValue)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)((NominalEntry)e).getDefault())) continue;
                    v0 = t;
                    break block11;
                }
                v0 = null;
            }
            KeyValue keyValue = v0;
            object = keyValue != null ? Integer.valueOf(keyValue.getKey()) : null;
        } else if (menuEntry instanceof RangeEntry) {
            String d;
            String string = ((RangeEntry)e).getDefault();
            if (string == null) {
                string = d = "";
            }
            if (((RangeEntry)e).getFilter()) {
                if (Intrinsics.areEqual((Object)d, (Object)"OFF")) {
                    object = "0";
                } else {
                    int di = Integer.parseInt(d);
                    object = this.getHcutFilters().contains(e.getId()) ? "" + (di - 50 - this.getHcutOffset()) / 50 : "" + (di - 50) / 50;
                }
            } else {
                object = d;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String d = object;
        if (d != null) {
            return d.toString();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void export(boolean changed_only, boolean include_title) {
        void $this$mapNotNullTo$iv$iv;
        this.logger.info("start");
        Iterable $this$mapNotNull$iv = this.getState().entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            MenuEntry e = this.getMenuService().findEntry(StringsKt.removePrefix((String)((CatCommand)it.getValue()).getCmd(), (CharSequence)this.getMENU_PREFIX()));
            if (e != null) {
                String d = this.getEntryDefault(e);
                if (changed_only) {
                    // empty if block
                }
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.example.ctrl891.model.IntValue");
                int value = ((IntValue)v).getValue();
                String valueString = String.valueOf(value);
                if (!Intrinsics.areEqual((Object)d, (Object)valueString) || !changed_only) {
                    Object[] objectArray = new Object[]{((CatCommand)it.getValue()).getCmd(), value};
                    List list2 = CollectionsKt.listOf((Object[])objectArray);
                    list = !include_title ? list2 : CollectionsKt.plus((Collection)list2, (Object)e.getName());
                } else {
                    list = null;
                }
            } else {
                this.logger.warn("menu entry not found " + ((CatCommand)it.getValue()).getCmd());
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List rows = (List)destination$iv$iv;
        LocalDate d = LocalDate.now();
        LocalTime t = LocalTime.now().truncatedTo(ChronoUnit.SECONDS);
        String string = d.toString();
        String string2 = t.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String str = string + " " + StringsKt.replace$default((String)string2, (char)':', (char)'_', (boolean)false, (int)4, null);
        String type1 = changed_only ? "[part]" : "[full]";
        new File(this.getDir()).mkdirs();
        File outFile = new File(this.getDir(), "menu-export " + type1 + " " + str + ".csv");
        this.logger.info("write file " + outFile);
        CsvWriter.writeAll$default((CsvWriter)CsvWriterDslKt.csvWriter$default(null, (int)1, null), (List)rows, (File)outFile, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> list() {
        void $this$mapTo$iv$iv;
        if (!new File(this.getDir()).exists()) {
            return CollectionsKt.emptyList();
        }
        Path path = Paths.get(this.getDir(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PathsKt.getName((Path)it));
        }
        List files = (List)destination$iv$iv;
        return files;
    }

    /*
     * WARNING - void declaration
     */
    public void import(@NotNull String name) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ImportItem it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String n = StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)"/", (String)"", (boolean)false, (int)4, null), (String)"\\", (String)"", (boolean)false, (int)4, null);
        File file = new File(this.getDir(), n);
        if (!file.exists()) {
            return;
        }
        this.logger.info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        CsvReader r2 = CsvReaderDslKt.csvReader((Function1)((Function1)import.r.1.INSTANCE));
        List rows = r2.readAll(file);
        Iterable $this$map$iv = rows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ImportItem((String)it.get(0), (String)it.get(1)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ImportItem)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it.getId(), (String)this.getMENU_PREFIX(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ImportItem)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it.getId(), (String)(this.getMENU_PREFIX() + "17"), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ImportItem)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it.getId(), (String)(this.getMENU_PREFIX() + "18"), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ImportItem)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)(this.getMENU_PREFIX() + "0506")))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importData = (List)destination$iv$iv;
        long sleeptime = 40L;
        this.logger.info("importing " + importData.size() + " elements");
        int total = importData.size();
        int count = 0;
        Iterable $this$forEach$iv = importData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImportItem it2 = (ImportItem)element$iv;
            boolean bl = false;
            try {
                this.logger.info("import menu entry " + it2.getId() + ": " + it2.getValue());
                String cmd = StringsKt.removePrefix((String)it2.getId(), (CharSequence)this.getMENU_PREFIX());
                int value = Integer.parseInt(it2.getValue());
                CatService catService = this.getCatService();
                Intrinsics.checkNotNull((Object)catService);
                catService.sendMenuSet(cmd, value);
                this.getMessageService().addCatMessage((CatCommand)new CAT_MENU_LOAD_PROGRESS(null, ++count, total, 1, null));
                Thread.sleep(sleeptime);
            }
            catch (Exception e) {
                this.logger.warn("Could not import line " + it2 + " : " + e);
            }
        }
        this.logger.info("import done");
    }
}

