/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.SettingsCmd;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.MessageService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/example/ctrl891/service/CoreService;", "", "messageService", "Lcom/example/ctrl891/service/MessageService;", "(Lcom/example/ctrl891/service/MessageService;)V", "buildNr", "", "getBuildNr", "()Ljava/lang/String;", "setBuildNr", "(Ljava/lang/String;)V", "comPortName", "comment", "getComment", "filename", "getFilename", "logger", "Lmu/KLogger;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "propnamePort", "getPropnamePort", "propnameReconnect", "getPropnameReconnect", "reconnect", "", "createProperties", "", "getComPortName", "getProjectProperties", "Ljava/util/Properties;", "init", "isReconnect", "loadProperties", "saveProperties", "updateSettings", "cmd", "Lcom/example/ctrl891/model/SettingsCmd;", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nCoreService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreService.kt\ncom/example/ctrl891/service/CoreService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,131:1\n1#2:132\n1271#3,2:133\n1285#3,4:135\n215#4,2:139\n*S KotlinDebug\n*F\n+ 1 CoreService.kt\ncom/example/ctrl891/service/CoreService\n*L\n78#1:133,2\n78#1:135,4\n79#1:139,2\n*E\n"})
public class CoreService {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private String buildNr;
    @NotNull
    private final String filename;
    @NotNull
    private final String comment;
    @NotNull
    private final String propnamePort;
    @NotNull
    private final String propnameReconnect;
    @Nullable
    private String comPortName;
    private boolean reconnect;

    public CoreService(@NotNull MessageService messageService) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        this.messageService = messageService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.buildNr = "";
        this.filename = "891ctrl.properties";
        this.comment = " - 891ctrl settings -";
        this.propnamePort = "serial.comPortName";
        this.propnameReconnect = "serial.reconnect";
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public String getBuildNr() {
        return this.buildNr;
    }

    public void setBuildNr(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.buildNr = string;
    }

    public void init() {
        try {
            Properties p = this.getProjectProperties();
            this.logger.info("project.version = " + p.getProperty("project.version"));
            String string = p.getProperty("project.build");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            this.setBuildNr(string);
            this.logger.info("project.build = " + this.getBuildNr());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        this.createProperties();
        this.loadProperties();
    }

    @NotNull
    public String getFilename() {
        return this.filename;
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public String getPropnamePort() {
        return this.propnamePort;
    }

    @NotNull
    public String getPropnameReconnect() {
        return this.propnameReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProperties() {
        File file = new File(this.getFilename());
        if (file.exists()) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty(this.getPropnamePort(), "");
        prop.setProperty(this.getPropnameReconnect(), "true");
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            prop.store(it, this.getComment());
            this.logger.info("created settings file: " + this.getFilename());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void loadProperties() {
        File file = new File(this.getFilename());
        Properties prop = new Properties();
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            prop.load(it);
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info("loaded settings file: " + file.getAbsolutePath());
        Set<String> set = prop.stringPropertyNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"stringPropertyNames(...)");
        Iterable $this$associateWith$iv = set;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            String string2 = prop.getProperty((String)it);
            map2.put(t, string2);
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.logger.info("" + it);
        }
        this.comPortName = prop.getProperty(this.getPropnamePort());
        String string = prop.getProperty(this.getPropnameReconnect());
        this.reconnect = string != null ? string.equals("true") : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        this.logger.info("saveProperties");
        Properties prop = new Properties();
        Closeable closeable = new FileOutputStream(this.getFilename());
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            prop.setProperty(this.getPropnamePort(), this.comPortName);
            prop.setProperty(this.getPropnameReconnect(), String.valueOf(this.reconnect));
            prop.store(it, this.getComment());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    @Nullable
    public String getComPortName() {
        return this.comPortName;
    }

    public void updateSettings(@NotNull SettingsCmd cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (cmd.getSystemPortName() != null) {
            this.comPortName = cmd.getSystemPortName();
        }
        if (cmd.getReconnect() != null) {
            this.reconnect = cmd.getReconnect();
        }
        this.saveProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Properties getProjectProperties() {
        InputStream inputStream = new ClassPathResource("project.properties").getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream resource = inputStream;
        Properties prop = new Properties();
        Closeable closeable = resource;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            prop.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return prop;
    }
}

