/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.CatCommandList;
import com.example.ctrl891.model.IF;
import com.example.ctrl891.model.MODE_EX;
import com.example.ctrl891.model.StringValue;
import com.example.ctrl891.service.CatStore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRT\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/example/ctrl891/service/CatStore;", "", "()V", "logger", "Lmu/KLogger;", "mapModeToSideExId", "", "Lcom/example/ctrl891/service/CatStore$ModeExId;", "getMapModeToSideExId", "()Ljava/util/List;", "state", "", "", "kotlin.jvm.PlatformType", "Lcom/example/ctrl891/model/CatCommand;", "", "getState", "()Ljava/util/Map;", "determineModeWithSideband", "Lcom/example/ctrl891/model/MODE_EX;", "isA", "", "get", "cmd", "getFreq", "", "(Z)Ljava/lang/Integer;", "getMapped", "Lcom/example/ctrl891/model/CatCommandList;", "put", "", "x", "ModeExId", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nCatStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatStore.kt\ncom/example/ctrl891/service/CatStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1855#2,2:106\n1#3:108\n*S KotlinDebug\n*F\n+ 1 CatStore.kt\ncom/example/ctrl891/service/CatStore\n*L\n16#1:106,2\n*E\n"})
public class CatStore {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private final Map<String, CatCommand> state = Collections.synchronizedMap(new LinkedHashMap());
    @NotNull
    private final List<ModeExId> mapModeToSideExId;

    public CatStore() {
        Object[] objectArray = new ModeExId[]{new ModeExId("SSB", "BFO_SIDE_SSB"), new ModeExId("CW", "BFO_SIDE_CW"), new ModeExId("RTTY", "BFO_SIDE_RTTY"), new ModeExId("DATA", "BFO_SIDE_DATA")};
        this.mapModeToSideExId = CollectionsKt.listOf((Object[])objectArray);
    }

    public Map<String, CatCommand> getState() {
        return this.state;
    }

    public void put(@NotNull List<? extends CatCommand> x) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Iterable $this$forEach$iv = x;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CatCommand it = (CatCommand)element$iv;
            boolean bl = false;
            this.getState().put(it.getCmd(), it);
        }
    }

    @Nullable
    public CatCommand get(@NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return (CatCommand)this.getState().get(cmd);
    }

    @Nullable
    public CatCommand getMapped(@NotNull CatCommandList cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return (CatCommand)this.getState().get(cmd.getCode());
    }

    @NotNull
    public List<ModeExId> getMapModeToSideExId() {
        return this.mapModeToSideExId;
    }

    @Nullable
    public Integer getFreq(boolean isA) {
        CatCommand information = isA ? this.get("INFORMATION") : this.get("INFORMATION2");
        Integer freq = information != null && information instanceof IF ? Integer.valueOf(((IF)information).getFreq()) : null;
        return freq;
    }

    public static /* synthetic */ Integer getFreq$default(CatStore catStore, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFreq");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return catStore.getFreq(bl);
    }

    @NotNull
    public MODE_EX determineModeWithSideband(boolean isA) {
        String sidebandWithAuto;
        CatCommand side;
        Object v1;
        Integer freq;
        String modeNoSideband;
        String modeId;
        block50: {
            CatCommand mode = this.get("MODE");
            modeNoSideband = switch (modeId = mode != null && mode instanceof StringValue ? ((StringValue)mode).getValue() : "-") {
                case "1", "2" -> "SSB";
                case "3", "7" -> "CW";
                case "B", "4" -> "FM";
                case "D", "5" -> "AM";
                case "6", "9" -> "RTTY";
                case "C", "8" -> "DATA";
                default -> "?";
            };
            freq = this.getFreq(isA);
            Iterable iterable = this.getMapModeToSideExId();
            for (Object t : iterable) {
                Object it = (ModeExId)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)modeNoSideband)) continue;
                v1 = t;
                break block50;
            }
            v1 = null;
        }
        ModeExId modeMap = v1;
        String string = modeMap != null ? ((side = this.get(modeMap.getId())) != null && side instanceof StringValue ? ((StringValue)side).getValue() : "") : (sidebandWithAuto = "");
        String sidebandCalculated = Intrinsics.areEqual((Object)sidebandWithAuto, (Object)"AUTO") ? (freq == null ? "" : (freq < 10000000 ? "LSB" : "USB")) : (sidebandWithAuto != null ? sidebandWithAuto : "");
        String modeWithSideband = Intrinsics.areEqual((Object)modeNoSideband, (Object)"SSB") ? sidebandCalculated : modeNoSideband;
        String modeFlrig = switch (modeNoSideband) {
            case "SSB" -> {
                if (Intrinsics.areEqual((Object)sidebandCalculated, (Object)"LSB")) {
                    yield "LSB";
                }
                yield "USB";
            }
            case "RTTY", "CW", "DATA" -> modeNoSideband + (Intrinsics.areEqual((Object)sidebandCalculated, (Object)"LSB") ? "-L" : "-U");
            default -> modeNoSideband;
        };
        MODE_EX m = new MODE_EX(null, modeId, modeWithSideband, modeNoSideband, modeFlrig, sidebandCalculated, sidebandWithAuto, 1, null);
        return m;
    }

    public static /* synthetic */ MODE_EX determineModeWithSideband$default(CatStore catStore, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: determineModeWithSideband");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return catStore.determineModeWithSideband(bl);
    }
}

