/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.generator.MenuService;
import com.example.ctrl891.model.CAT_GENERIC_MESSAGE;
import com.example.ctrl891.model.CAT_MENU_LOAD_PROGRESS;
import com.example.ctrl891.model.CAT_STATE;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.CatCommandList;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.model.KeyValue;
import com.example.ctrl891.model.MenuEntry;
import com.example.ctrl891.model.NominalEntry;
import com.example.ctrl891.model.RangeEntry;
import com.example.ctrl891.model.StringValue;
import com.example.ctrl891.model.UnknownCatCmd;
import com.example.ctrl891.model.WIDTH;
import com.example.ctrl891.service.CatCallback;
import com.example.ctrl891.service.CatHook;
import com.example.ctrl891.service.CatParser;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.CatStore;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.SerialService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b*\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010R\u001a\u00020*H\u0016J\u0016\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VH\u0012J\b\u0010X\u001a\u00020*H\u0016J\b\u0010Y\u001a\u00020TH\u0016J\u0018\u0010Z\u001a\u00020T2\u0006\u0010[\u001a\u00020*2\u0006\u0010\\\u001a\u00020*H\u0016J\b\u0010]\u001a\u00020TH\u0016J\b\u0010^\u001a\u00020TH\u0016J\b\u0010_\u001a\u00020*H\u0016J\b\u0010`\u001a\u00020TH\u0016J\b\u0010a\u001a\u00020TH\u0016J\u0016\u0010b\u001a\u00020T2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u001a0VH\u0016J\b\u0010d\u001a\u00020TH\u0016J\b\u0010e\u001a\u00020TH\u0016J\b\u0010f\u001a\u00020TH\u0012J\u0018\u0010g\u001a\u00020T2\u0006\u0010h\u001a\u00020M2\u0006\u0010i\u001a\u00020*H\u0016J\u0018\u0010j\u001a\u00020T2\u0006\u0010k\u001a\u00020\u001a2\u0006\u0010l\u001a\u00020\u001aH\u0016J\u0018\u0010m\u001a\u00020T2\u0006\u0010k\u001a\u00020\u001a2\u0006\u0010l\u001a\u00020\u001aH\u0016J\u0018\u0010n\u001a\u00020T2\u0006\u0010k\u001a\u00020\u001a2\u0006\u0010o\u001a\u00020\u0016H\u0016J\u0010\u0010p\u001a\u00020T2\u0006\u0010q\u001a\u00020\u001aH\u0016J\u0010\u0010r\u001a\u00020T2\u0006\u0010h\u001a\u00020MH\u0016J\u0010\u0010s\u001a\u00020T2\u0006\u0010k\u001a\u00020\u001aH\u0016J\u0010\u0010t\u001a\u00020T2\u0006\u0010q\u001a\u00020\u001aH\u0012J\u0018\u0010u\u001a\u00020T2\u0006\u0010h\u001a\u00020M2\u0006\u0010o\u001a\u00020\u001aH\u0016J\u0018\u0010v\u001a\u00020T2\u0006\u0010h\u001a\u00020M2\u0006\u0010o\u001a\u00020\u001aH\u0016J\u0010\u0010w\u001a\u00020T2\u0006\u0010o\u001a\u00020\u001aH\u0016J\u0010\u0010x\u001a\u00020T2\u0006\u0010y\u001a\u00020\u0016H\u0016J\u001a\u0010z\u001a\u00020T2\u0006\u0010y\u001a\u00020\u00162\b\b\u0002\u0010{\u001a\u00020*H\u0016J\u0010\u0010|\u001a\u00020T2\u0006\u0010}\u001a\u00020\u001aH\u0016J\u0010\u0010~\u001a\u00020T2\u0006\u0010\u007f\u001a\u00020\u001aH\u0016J\t\u0010\u0080\u0001\u001a\u00020TH\u0016R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u001a\u0010)\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0014R\u001a\u00101\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0018\"\u0004\b3\u00104R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0010\u00107\u001a\u0004\u0018\u000108X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020*X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020*X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001c\"\u0004\b=\u0010>R\u0012\u0010?\u001a\u00020*8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020\u0012X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0012X\u0092D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0014\u0010J\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0014R\u001c\u0010L\u001a\u0004\u0018\u00010MX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010Q\u00a8\u0006\u0081\u0001"}, d2={"Lcom/example/ctrl891/service/CatService;", "Lcom/example/ctrl891/service/CatCallback;", "serialService", "Lcom/example/ctrl891/service/SerialService;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "menuService", "Lcom/example/ctrl891/generator/MenuService;", "coreService", "Lcom/example/ctrl891/service/CoreService;", "catParser", "Lcom/example/ctrl891/service/CatParser;", "catHook", "Lcom/example/ctrl891/service/CatHook;", "catStore", "Lcom/example/ctrl891/service/CatStore;", "(Lcom/example/ctrl891/service/SerialService;Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/generator/MenuService;Lcom/example/ctrl891/service/CoreService;Lcom/example/ctrl891/service/CatParser;Lcom/example/ctrl891/service/CatHook;Lcom/example/ctrl891/service/CatStore;)V", "QUERY_AFTER_UPDATE_DELAY_TIME", "", "getQUERY_AFTER_UPDATE_DELAY_TIME", "()J", "blinkCycles", "", "getBlinkCycles", "()I", "blinkId", "", "getBlinkId", "()Ljava/lang/String;", "blinkMax", "getBlinkMax", "blinkMin", "getBlinkMin", "getCatHook", "()Lcom/example/ctrl891/service/CatHook;", "getCatParser", "()Lcom/example/ctrl891/service/CatParser;", "getCatStore", "()Lcom/example/ctrl891/service/CatStore;", "check891_attempts", "getCheck891_attempts", "check891_foundRadio", "", "getCheck891_foundRadio", "()Z", "setCheck891_foundRadio", "(Z)V", "check891_sleeptime", "getCheck891_sleeptime", "connectAttemptCount", "getConnectAttemptCount", "setConnectAttemptCount", "(I)V", "getCoreService", "()Lcom/example/ctrl891/service/CoreService;", "executionThread", "Ljava/lang/Thread;", "isConnecting", "isRequestConnect", "lastQuery", "getLastQuery", "setLastQuery", "(Ljava/lang/String;)V", "log", "logger", "Lmu/KLogger;", "getMenuService", "()Lcom/example/ctrl891/generator/MenuService;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "reconnectSleeptime", "requestConnectSleeptime", "getSerialService", "()Lcom/example/ctrl891/service/SerialService;", "sleeptime", "getSleeptime", "waitForQuery", "Lcom/example/ctrl891/model/CatCommandList;", "getWaitForQuery", "()Lcom/example/ctrl891/model/CatCommandList;", "setWaitForQuery", "(Lcom/example/ctrl891/model/CatCommandList;)V", "checkFor891", "checkModel", "", "lines", "", "Lcom/example/ctrl891/model/CatCommand;", "connectAndBlock", "connectedBlock", "connectionState", "connected", "identified", "disconnect", "exportMenuState", "isReconnect", "loadMenuState", "loadState", "processCatIn", "x", "requestConnect", "runConnectLoop", "runStartupBlink", "sendBoolean", "c", "enabled", "sendMenuAndQuery", "id", "num", "sendMenuAndQueryRaw", "sendMenuSet", "value", "sendPublic", "t", "sendQuery", "sendQueryMenu", "sendRaw", "sendUpdate", "sendUpdateAndQuery", "sendUpdateMultiline", "setClar", "f", "setFreq", "isA", "setMode", "m", "setModeFromString", "name", "start", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nCatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatService.kt\ncom/example/ctrl891/service/CatService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,484:1\n1549#2:485\n1620#2,3:486\n1855#2,2:492\n1855#2,2:494\n1855#2,2:496\n1855#2,2:498\n766#2:500\n857#2,2:501\n1549#2:503\n1620#2,3:504\n1855#2,2:507\n766#2:509\n857#2,2:510\n3792#3:489\n4307#3,2:490\n*S KotlinDebug\n*F\n+ 1 CatService.kt\ncom/example/ctrl891/service/CatService\n*L\n219#1:485\n219#1:486,3\n285#1:492,2\n299#1:494,2\n311#1:496,2\n341#1:498,2\n351#1:500\n351#1:501,2\n351#1:503\n351#1:504,3\n359#1:507,2\n407#1:509\n407#1:510,2\n285#1:489\n285#1:490,2\n*E\n"})
public class CatService
implements CatCallback {
    @NotNull
    private final SerialService serialService;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final MenuService menuService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CatParser catParser;
    @NotNull
    private final CatHook catHook;
    @NotNull
    private final CatStore catStore;
    @NotNull
    private final KLogger logger;
    @Value(value="${serial.log:false}")
    private boolean log;
    @Nullable
    private Thread executionThread;
    private final long QUERY_AFTER_UPDATE_DELAY_TIME;
    private boolean isRequestConnect;
    private boolean isConnecting;
    private final long reconnectSleeptime;
    private final long requestConnectSleeptime;
    private int connectAttemptCount;
    private final long sleeptime;
    @NotNull
    private String lastQuery;
    private final long check891_sleeptime;
    private final int check891_attempts;
    private boolean check891_foundRadio;
    @Nullable
    private CatCommandList waitForQuery;
    @NotNull
    private final String blinkId;
    private final int blinkMin;
    private final int blinkMax;
    private final int blinkCycles;

    public CatService(@NotNull SerialService serialService, @NotNull MessageService messageService, @NotNull MenuService menuService, @NotNull CoreService coreService, @NotNull CatParser catParser, @NotNull CatHook catHook, @NotNull CatStore catStore) {
        Intrinsics.checkNotNullParameter((Object)serialService, (String)"serialService");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)menuService, (String)"menuService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)catParser, (String)"catParser");
        Intrinsics.checkNotNullParameter((Object)catHook, (String)"catHook");
        Intrinsics.checkNotNullParameter((Object)catStore, (String)"catStore");
        this.serialService = serialService;
        this.messageService = messageService;
        this.menuService = menuService;
        this.coreService = coreService;
        this.catParser = catParser;
        this.catHook = catHook;
        this.catStore = catStore;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.QUERY_AFTER_UPDATE_DELAY_TIME = 100L;
        this.reconnectSleeptime = 5000L;
        this.requestConnectSleeptime = 1000L;
        this.sleeptime = 40L;
        this.lastQuery = "";
        this.check891_sleeptime = 100L;
        this.check891_attempts = 20;
        this.blinkId = "0203";
        this.blinkMin = 2;
        this.blinkMax = 4;
        this.blinkCycles = 5;
    }

    @NotNull
    public SerialService getSerialService() {
        return this.serialService;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public MenuService getMenuService() {
        return this.menuService;
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @NotNull
    public CatParser getCatParser() {
        return this.catParser;
    }

    @NotNull
    public CatHook getCatHook() {
        return this.catHook;
    }

    @NotNull
    public CatStore getCatStore() {
        return this.catStore;
    }

    public long getQUERY_AFTER_UPDATE_DELAY_TIME() {
        return this.QUERY_AFTER_UPDATE_DELAY_TIME;
    }

    public void start() {
        this.getCatHook().start(this);
        this.logger.info("start");
        this.logger.info("reconnect = " + this.isReconnect());
        if (this.isReconnect()) {
            this.isRequestConnect = true;
        }
        this.executionThread = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"CatService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public boolean isReconnect() {
        return this.getCoreService().isReconnect();
    }

    public void requestConnect() {
        this.isRequestConnect = true;
    }

    public void disconnect() {
        this.getSerialService().disconnect();
    }

    public int getConnectAttemptCount() {
        return this.connectAttemptCount;
    }

    public void setConnectAttemptCount(int n) {
        this.connectAttemptCount = n;
    }

    public void runConnectLoop() {
        this.setConnectAttemptCount(0);
        while (true) {
            if (!this.isRequestConnect) {
                Thread.sleep(this.requestConnectSleeptime);
                this.setConnectAttemptCount(0);
                continue;
            }
            this.isConnecting = true;
            this.isRequestConnect = false;
            boolean connectSuccess = this.connectAndBlock();
            int n = this.getConnectAttemptCount();
            this.setConnectAttemptCount(n + 1);
            if (connectSuccess) {
                this.setConnectAttemptCount(0);
            }
            this.isConnecting = false;
            this.isRequestConnect = false;
            if (!this.isReconnect()) continue;
            Thread.sleep(this.reconnectSleeptime);
            this.isRequestConnect = true;
        }
    }

    public boolean connectAndBlock() {
        if (this.getSerialService().connect((CatCallback)this, this.getConnectAttemptCount())) {
            Thread.sleep(1000L);
            if (!this.checkFor891()) {
                this.disconnect();
                return false;
            }
            this.connectionState(true, true);
            this.getMessageService().addCatMessage((CatCommand)new CAT_GENERIC_MESSAGE(null, "connected to 891", 1, null));
            this.connectedBlock();
            return true;
        }
        return false;
    }

    public void connectedBlock() {
        this.sendUpdate(CatCommandList.AUTO_INFORMATION, "1");
        Thread.sleep(100L);
        this.loadState();
        Thread.sleep(100L);
        this.runStartupBlink();
        while (this.getSerialService().isConnected()) {
            Thread.sleep(2000L);
        }
    }

    public void sendQuery(@NotNull CatCommandList c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.sendRaw(c.getCode());
    }

    public void sendQueryMenu(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.sendRaw("EX" + id);
    }

    public void sendUpdate(@NotNull CatCommandList c, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sendRaw(c.getCode() + value);
    }

    public void sendUpdateMultiline(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sendRaw(value);
    }

    public void sendUpdateAndQuery(@NotNull CatCommandList c, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String a = value;
        this.sendRaw(c.getCode() + a);
        Thread.sleep(this.getQUERY_AFTER_UPDATE_DELAY_TIME());
        this.sendRaw(c.getCode());
    }

    /*
     * WARNING - void declaration
     */
    public void sendMenuSet(@NotNull String id, int value) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MenuEntry e = this.getMenuService().findEntry(id);
        if (e != null) {
            if (e instanceof RangeEntry) {
                Object object;
                int min = ((RangeEntry)e).getMin();
                int max = ((RangeEntry)e).getMax();
                int digits = ((RangeEntry)e).getDigits();
                if (!(((RangeEntry)e).getFilter() || value <= max && value >= min)) {
                    this.logger.warn("Skip invalid value " + value + " for menu entry " + id + " (min=" + ((RangeEntry)e).getMin() + ", max=" + ((RangeEntry)e).getMax() + ")");
                    return;
                }
                if (min < 0) {
                    String prefix = value >= 0 ? "+" : "-";
                    int value1 = value >= 0 ? value : 0 - value;
                    object = prefix + StringsKt.padStart((String)String.valueOf(value1), (int)(digits - 1), (char)'0');
                } else {
                    object = StringsKt.padStart((String)String.valueOf(value), (int)digits, (char)'0');
                }
                String num = object;
                this.sendMenuAndQuery(id, num);
            } else if (e instanceof NominalEntry) {
                void $this$mapTo$iv$iv;
                int digits = ((NominalEntry)e).getDigits();
                Iterable $this$map$iv = ((NominalEntry)e).getValues();
                boolean $i$f$map = false;
                Iterable prefix = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KeyValue keyValue = (KeyValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKey());
                }
                List keys = (List)destination$iv$iv;
                if (!keys.contains(value)) {
                    this.logger.warn("Skip invalid value " + value + " for menu entry " + id + " (allowed values = " + keys + ")");
                    return;
                }
                String num = StringsKt.padStart((String)String.valueOf(value), (int)digits, (char)'0');
                this.sendMenuAndQuery(id, num);
            }
        }
    }

    public void sendMenuAndQueryRaw(@NotNull String id, @NotNull String num) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        this.sendRaw(id + num);
        Thread.sleep(this.getQUERY_AFTER_UPDATE_DELAY_TIME());
        this.sendRaw(id);
    }

    public void sendMenuAndQuery(@NotNull String id, @NotNull String num) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        this.sendRaw("EX" + id + num);
        Thread.sleep(this.getQUERY_AFTER_UPDATE_DELAY_TIME());
        this.sendRaw("EX" + id);
    }

    public void sendBoolean(@NotNull CatCommandList c, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int a = enabled ? 1 : 0;
        this.sendRaw(c.getCode() + a);
    }

    public void setFreq(int f2, boolean isA) {
        String fs = StringsKt.padStart((String)String.valueOf(f2), (int)9, (char)'0');
        if (isA) {
            this.sendRaw("FA" + fs);
        } else {
            this.sendRaw("FB" + fs);
        }
    }

    public static /* synthetic */ void setFreq$default(CatService catService, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setFreq");
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        catService.setFreq(n, bl);
    }

    public void setClar(int f2) {
        if (f2 == 0) {
            this.sendRaw("RC");
        } else {
            boolean isNeg = f2 < 0;
            int f22 = isNeg ? f2 * -1 : f2;
            String fs = StringsKt.padStart((String)String.valueOf(f22), (int)4, (char)'0');
            if (isNeg) {
                this.sendRaw("RD" + fs);
            } else {
                this.sendRaw("RU" + fs);
            }
        }
    }

    public void sendPublic(@NotNull String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.sendRaw(t);
    }

    private void sendRaw(String t) {
        this.setLastQuery(t);
        this.getSerialService().send(t);
    }

    public void setMode(@NotNull String m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.sendRaw("MD0" + m);
        Thread.sleep(this.getQUERY_AFTER_UPDATE_DELAY_TIME());
    }

    public long getSleeptime() {
        return this.sleeptime;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState() {
        void $this$filterTo$iv$iv;
        Thread.sleep(100L);
        CatCommandList[] $this$filter$iv = CatCommandList.values();
        boolean $i$f$filter = false;
        CatCommandList[] catCommandListArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!it.getSkipRefresh())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CatCommandList it = (CatCommandList)element$iv;
            boolean bl = false;
            Thread.sleep(this.getSleeptime());
            this.sendQuery(it);
        }
        Thread.sleep(this.getSleeptime());
        this.sendQueryMenu(this.getBlinkId());
        Thread.sleep(this.getSleeptime());
    }

    public void loadMenuState() {
        int total = this.getMenuService().getEntries().size();
        int count = 0;
        Iterable $this$forEach$iv = this.getMenuService().getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MenuEntry it = (MenuEntry)element$iv;
            boolean bl = false;
            this.logger.debug("load " + it.getId() + " " + it.getName());
            Thread.sleep(this.getSleeptime());
            this.sendQueryMenu(it.getId());
            this.getMessageService().addCatMessage((CatCommand)new CAT_MENU_LOAD_PROGRESS(null, ++count, total, 1, null));
        }
    }

    public void exportMenuState() {
        int total = this.getMenuService().getEntries().size();
        int count = 0;
        Iterable $this$forEach$iv = this.getMenuService().getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MenuEntry it = (MenuEntry)element$iv;
            boolean bl = false;
            this.logger.debug("load " + it.getId() + " " + it.getName());
            Thread.sleep(this.getSleeptime());
            this.sendQueryMenu(it.getId());
            this.getMessageService().addCatMessage((CatCommand)new CAT_MENU_LOAD_PROGRESS(null, ++count, total, 1, null));
        }
    }

    public void connectionState(boolean connected, boolean identified) {
        CAT_STATE m = new CAT_STATE(null, connected, identified, 1, null);
        this.getMessageService().addCatMessage((CatCommand)m);
        this.getCatHook().connectionState((CatCommand)m);
        if (!connected) {
            this.getSerialService().disconnect();
        }
    }

    @NotNull
    public String getLastQuery() {
        return this.lastQuery;
    }

    public void setLastQuery(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastQuery = string;
    }

    /*
     * WARNING - void declaration
     */
    public void processCatIn(@NotNull List<String> x) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CatCommand it;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        List x1 = this.getCatParser().parseLines(x);
        Iterable $this$forEach$iv = x1;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            CatCommand it2 = (CatCommand)element$iv2;
            boolean bl = false;
            if (!(it2 instanceof UnknownCatCmd)) continue;
            this.logger.warn("Could not parse: " + x + " - Q=" + this.getLastQuery());
        }
        this.checkModel(x1);
        this.getCatStore().put(x1);
        Iterable $this$filter$iv = x1;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CatCommand)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCmd(), (Object)"MODE")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CatCommand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CatStore.determineModeWithSideband$default((CatStore)this.getCatStore(), (boolean)false, (int)1, null));
        }
        List x2 = (List)destination$iv$iv;
        List x3 = CollectionsKt.plus((Collection)x1, (Iterable)x2);
        this.getMessageService().addCatMessages(x3);
        this.getCatHook().processCommand(x3);
        Iterable $this$forEach$iv2 = x1;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            CatCommand it3 = (CatCommand)element$iv3;
            boolean bl = false;
            if (!(it3 instanceof WIDTH)) continue;
            this.sendQuery(CatCommandList.NARROW);
        }
    }

    public long getCheck891_sleeptime() {
        return this.check891_sleeptime;
    }

    public int getCheck891_attempts() {
        return this.check891_attempts;
    }

    public boolean getCheck891_foundRadio() {
        return this.check891_foundRadio;
    }

    public void setCheck891_foundRadio(boolean bl) {
        this.check891_foundRadio = bl;
    }

    @Nullable
    public CatCommandList getWaitForQuery() {
        return this.waitForQuery;
    }

    public void setWaitForQuery(@Nullable CatCommandList catCommandList) {
        this.waitForQuery = catCommandList;
    }

    public boolean checkFor891() {
        this.setCheck891_foundRadio(false);
        this.setWaitForQuery(CatCommandList.IDENTIFICATION);
        this.sendQuery(CatCommandList.IDENTIFICATION);
        int count = 0;
        while (!this.getCheck891_foundRadio()) {
            Thread.sleep(this.getCheck891_sleeptime());
            if (++count <= this.getCheck891_attempts()) continue;
            String text = "failed to read 891 identification";
            this.setWaitForQuery(null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void checkModel(List<? extends CatCommand> lines) {
        CatCommandList q = this.getWaitForQuery();
        if (q != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = lines;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CatCommand it = (CatCommand)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getCmd(), (Object)q.name()) && it instanceof StringValue && Intrinsics.areEqual((Object)((StringValue)it).getValue(), (Object)"0650"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List id = (List)destination$iv$iv;
            if (id.size() > 0) {
                this.logger.info("------- connected to 891 ---------");
                this.setWaitForQuery(null);
                this.setCheck891_foundRadio(true);
            }
        }
    }

    @NotNull
    public String getBlinkId() {
        return this.blinkId;
    }

    public int getBlinkMin() {
        return this.blinkMin;
    }

    public int getBlinkMax() {
        return this.blinkMax;
    }

    public int getBlinkCycles() {
        return this.blinkCycles;
    }

    private void runStartupBlink() {
        Ref.IntRef initialState = new Ref.IntRef();
        CatCommand value = this.getCatStore().get("EX" + this.getBlinkId());
        if (value != null && value instanceof IntValue) {
            initialState.element = ((IntValue)value).getValue();
        }
        this.logger.info("runStartupBlink " + initialState.element);
        Ref.IntRef count = new Ref.IntRef();
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"StartupBlink", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public void setModeFromString(@NotNull String name) {
        String p1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String p = string;
        boolean isLower = StringsKt.endsWith$default((String)p, (String)"-L", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)p, (Object)"LSB");
        String sideNumber = isLower ? "1" : "0";
        switch (p1 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)p, (CharSequence)"-L"), (CharSequence)"-U")) {
            case "USB": 
            case "LSB": {
                this.setMode("1");
                this.sendMenuAndQueryRaw(CatCommandList.BFO_SIDE_SSB.getCode(), sideNumber);
                break;
            }
            case "CW": {
                this.setMode("3");
                this.sendMenuAndQueryRaw(CatCommandList.BFO_SIDE_CW.getCode(), sideNumber);
                break;
            }
            case "DATA": {
                this.setMode("8");
                this.sendMenuAndQueryRaw(CatCommandList.BFO_SIDE_DATA.getCode(), sideNumber);
                break;
            }
            case "RTTY": {
                this.setMode("6");
                this.sendMenuAndQueryRaw(CatCommandList.BFO_SIDE_RTTY.getCode(), sideNumber);
                break;
            }
            case "AM": {
                this.setMode("5");
                break;
            }
            case "FM": {
                this.setMode("4");
            }
        }
    }
}

