/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.BooleanValue;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.CatCommandList;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.model.NoneValue;
import com.example.ctrl891.model.StringValue;
import com.example.ctrl891.model.UnknownCatCmd;
import com.example.ctrl891.service.CatParser;
import com.example.ctrl891.util.ParseUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/example/ctrl891/service/CatParser;", "", "()V", "filterMenuIds", "", "", "getFilterMenuIds", "()Ljava/util/List;", "log", "", "logAll", "getLogAll", "()Z", "logMeter", "getLogMeter", "logger", "Lmu/KLogger;", "modes", "Lcom/example/ctrl891/service/CatParser$ModeId;", "getModes", "createBoolean", "Lcom/example/ctrl891/model/BooleanValue;", "type", "Lcom/example/ctrl891/model/CatCommandList;", "text", "createBooleanInverted", "createInt", "Lcom/example/ctrl891/model/IntValue;", "createIntMapped", "Lcom/example/ctrl891/model/StringValue;", "createIntMappedInt", "createMenu", "createNone", "Lcom/example/ctrl891/model/NoneValue;", "createString", "parseLines", "Lcom/example/ctrl891/model/CatCommand;", "x", "ModeId", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nCatParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatParser.kt\ncom/example/ctrl891/service/CatParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1360#2:143\n1446#2,2:144\n1448#2,3:147\n1855#2,2:150\n1#3:146\n*S KotlinDebug\n*F\n+ 1 CatParser.kt\ncom/example/ctrl891/service/CatParser\n*L\n31#1:143\n31#1:144,2\n31#1:147,3\n63#1:150,2\n*E\n"})
public class CatParser {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Value(value="${serial.log:false}")
    private boolean log;
    private final boolean logAll;
    private final boolean logMeter;
    @NotNull
    private final List<String> filterMenuIds;
    @NotNull
    private final List<ModeId> modes;

    public CatParser() {
        this.logAll = true;
        Object[] objectArray = new String[]{"0601", "0603", "0701", "0703", "0805", "0807", "1001", "1003", "1101", "1103"};
        this.filterMenuIds = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ModeId[]{new ModeId("SSB", "1"), new ModeId("CW", "3"), new ModeId("DATA", "8"), new ModeId("RTTY", "6"), new ModeId("AM", "5"), new ModeId("FM", "4")};
        this.modes = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean getLogAll() {
        return this.logAll;
    }

    public boolean getLogMeter() {
        return this.logMeter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CatCommand> parseLines(@NotNull List<String> x) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Iterable $this$flatMap$iv = x;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            CatCommand cc;
            Object[] objectArray;
            String cmd;
            block19: {
                CatCommand catCommand;
                block18: {
                    CatCommandList entry;
                    block17: {
                        CatCommandList catCommandList;
                        cmd = (String)element$iv$iv;
                        boolean bl = false;
                        if ((!StringsKt.startsWith$default((String)cmd, (String)"RM", (boolean)false, (int)2, null) || this.getLogMeter()) && (this.log || StringsKt.startsWith$default((String)cmd, (String)CatCommandList.IDENTIFICATION.getCode(), (boolean)false, (int)2, null))) {
                            this.logger.info("CAT IN '" + cmd + "'");
                        }
                        objectArray = CatCommandList.values();
                        int n = objectArray.length;
                        for (int i = 0; i < n; ++i) {
                            CatCommandList catCommandList2;
                            CatCommandList it = catCommandList2 = objectArray[i];
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)cmd, (String)it.getCode(), (boolean)false, (int)2, null)) continue;
                            catCommandList = catCommandList2;
                            break block17;
                        }
                        catCommandList = entry = null;
                    }
                    if (entry == null) break block18;
                    switch (WhenMappings.$EnumSwitchMapping$0[entry.getType().ordinal()]) {
                        case 1: {
                            catCommand = (CatCommand)this.createString(entry, cmd);
                            break block19;
                        }
                        case 2: {
                            catCommand = (CatCommand)this.createInt(entry, cmd);
                            break block19;
                        }
                        case 3: {
                            catCommand = (CatCommand)this.createIntMapped(entry, cmd);
                            break block19;
                        }
                        case 4: {
                            catCommand = (CatCommand)this.createIntMappedInt(entry, cmd);
                            break block19;
                        }
                        case 5: {
                            catCommand = (CatCommand)this.createBoolean(entry, cmd);
                            break block19;
                        }
                        case 6: {
                            catCommand = (CatCommand)this.createBooleanInverted(entry, cmd);
                            break block19;
                        }
                        case 7: {
                            catCommand = (CatCommand)entry.getHandler().invoke((Object)cmd);
                            break block19;
                        }
                        case 8: {
                            catCommand = (CatCommand)this.createNone(entry, cmd);
                            break block19;
                        }
                        case 9: {
                            catCommand = (CatCommand)this.createMenu(entry, cmd);
                            break block19;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                catCommand = cc = (CatCommand)new UnknownCatCmd(null, cmd, 1, null);
            }
            if (StringsKt.startsWith$default((String)cmd, (String)CatCommandList.MENU_SETTING.getCode(), (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)cc.getCmd(), (String)"EX", (boolean)false, (int)2, null)) {
                objectArray = new CatCommand[]{cc, this.createMenu(CatCommandList.MENU_SETTING, cmd)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)cc);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List x1 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = x1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CatCommand it = (CatCommand)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getCmd(), (Object)"METER") && !this.getLogMeter()) continue;
            String pre = Intrinsics.areEqual((Object)it.getCmd(), (Object)"UnknownCatCmd") ? ">>>>>>>>>>>>>>>>> " : "";
            this.logger.debug(pre + "PARSED " + it);
        }
        return x1;
    }

    @NotNull
    public StringValue createString(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new StringValue(type.name(), ParseUtils.INSTANCE.substring(text, type.getCode().length() + 1, text.length()));
    }

    @NotNull
    public IntValue createInt(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new IntValue(type.name(), ParseUtils.INSTANCE.substringNumber(text, type.getCode().length() + 1, text.length()));
    }

    @NotNull
    public StringValue createIntMapped(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int num = ParseUtils.INSTANCE.substringNumber(text, type.getCode().length() + 1, text.length());
        Map map2 = type.getMap();
        String value = map2 != null ? (String)map2.get(num) : null;
        String string = type.name();
        String string2 = value;
        if (string2 == null) {
            string2 = "";
        }
        return new StringValue(string, string2);
    }

    @NotNull
    public IntValue createIntMappedInt(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int num = ParseUtils.INSTANCE.substringNumber(text, type.getCode().length() + 1, text.length());
        Object object = type.getMapInt();
        Integer value = object != null && (object = (Integer)object.get(num)) != null ? Integer.valueOf((Integer)object) : null;
        Integer n = value;
        return new IntValue(type.name(), n != null ? n : 0);
    }

    @NotNull
    public BooleanValue createBoolean(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new BooleanValue(type.name(), Boolean.valueOf(ParseUtils.INSTANCE.substringBooleanToEnd(text, type.getCode().length() + 1)));
    }

    @NotNull
    public BooleanValue createBooleanInverted(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new BooleanValue(type.name(), Boolean.valueOf(!ParseUtils.INSTANCE.substringBooleanToEnd(text, type.getCode().length() + 1)));
    }

    @NotNull
    public NoneValue createNone(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new NoneValue(type.name());
    }

    @NotNull
    public List<String> getFilterMenuIds() {
        return this.filterMenuIds;
    }

    @NotNull
    public IntValue createMenu(@NotNull CatCommandList type, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int value = ParseUtils.INSTANCE.substringNumber(text, 7, text.length());
        String menuId = ParseUtils.INSTANCE.substring(text, 3, 6);
        int value1 = value;
        String name = "EX" + menuId;
        return new IntValue(name, value1);
    }

    @NotNull
    public List<ModeId> getModes() {
        return this.modes;
    }
}

