/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.IF;
import com.example.ctrl891.model.MODE_EX;
import com.example.ctrl891.service.BatteryService;
import com.example.ctrl891.service.CatHook;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.CatStore;
import com.example.ctrl891.service.ExportService;
import com.example.ctrl891.service.RigctlService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0012X\u0093D\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/example/ctrl891/service/CatHook;", "", "rigctlService", "Lcom/example/ctrl891/service/RigctlService;", "batteryService", "Lcom/example/ctrl891/service/BatteryService;", "catStore", "Lcom/example/ctrl891/service/CatStore;", "exportService", "Lcom/example/ctrl891/service/ExportService;", "(Lcom/example/ctrl891/service/RigctlService;Lcom/example/ctrl891/service/BatteryService;Lcom/example/ctrl891/service/CatStore;Lcom/example/ctrl891/service/ExportService;)V", "getBatteryService", "()Lcom/example/ctrl891/service/BatteryService;", "getCatStore", "()Lcom/example/ctrl891/service/CatStore;", "getExportService", "()Lcom/example/ctrl891/service/ExportService;", "featurerigctl", "", "Ljava/lang/Boolean;", "logger", "Lmu/KLogger;", "getRigctlService", "()Lcom/example/ctrl891/service/RigctlService;", "connectionState", "", "m", "Lcom/example/ctrl891/model/CatCommand;", "processCommand", "x1", "", "start", "catService", "Lcom/example/ctrl891/service/CatService;", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nCatHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatHook.kt\ncom/example/ctrl891/service/CatHook\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1855#2,2:55\n*S KotlinDebug\n*F\n+ 1 CatHook.kt\ncom/example/ctrl891/service/CatHook\n*L\n37#1:55,2\n*E\n"})
public class CatHook {
    @NotNull
    private final RigctlService rigctlService;
    @NotNull
    private final BatteryService batteryService;
    @NotNull
    private final CatStore catStore;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final KLogger logger;
    @Value(value="${feature.rigctl:false}")
    @Nullable
    private final Boolean featurerigctl;

    public CatHook(@NotNull RigctlService rigctlService, @NotNull BatteryService batteryService, @NotNull CatStore catStore, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)rigctlService, (String)"rigctlService");
        Intrinsics.checkNotNullParameter((Object)batteryService, (String)"batteryService");
        Intrinsics.checkNotNullParameter((Object)catStore, (String)"catStore");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.rigctlService = rigctlService;
        this.batteryService = batteryService;
        this.catStore = catStore;
        this.exportService = exportService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.featurerigctl = false;
    }

    @NotNull
    public RigctlService getRigctlService() {
        return this.rigctlService;
    }

    @NotNull
    public BatteryService getBatteryService() {
        return this.batteryService;
    }

    @NotNull
    public CatStore getCatStore() {
        return this.catStore;
    }

    @NotNull
    public ExportService getExportService() {
        return this.exportService;
    }

    public void start(@NotNull CatService catService) {
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        if (Intrinsics.areEqual((Object)this.featurerigctl, (Object)true)) {
            this.getRigctlService().start(catService);
        }
        this.getExportService().init(catService);
    }

    public void connectionState(@NotNull CatCommand m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.getBatteryService().processEvent(m);
    }

    public void processCommand(@NotNull List<? extends CatCommand> x1) {
        Intrinsics.checkNotNullParameter(x1, (String)"x1");
        Iterable $this$forEach$iv = x1;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CatCommand it = (CatCommand)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.featurerigctl, (Object)true)) {
                if (it instanceof IF && Intrinsics.areEqual((Object)it.getCmd(), (Object)"INFORMATION")) {
                    int f2 = ((IF)it).getFreq();
                    this.getRigctlService().sendFreq(f2);
                } else if (it instanceof MODE_EX) {
                    this.getRigctlService().updateMode((MODE_EX)it);
                }
            }
            this.getBatteryService().processEvent(it);
            this.getExportService().add(x1);
        }
    }
}

