/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.BooleanValue;
import com.example.ctrl891.model.CAT_BATTERY_INFO;
import com.example.ctrl891.model.CAT_STATE;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.service.BatteryInfo;
import com.example.ctrl891.service.BatteryService;
import com.example.ctrl891.service.MessageService;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020*H\u0016J\u0010\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\fH\u0016J\b\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0016J\u0012\u0010K\u001a\u00020\u00062\b\b\u0002\u0010E\u001a\u00020\fH\u0016J\b\u0010L\u001a\u00020GH\u0016J\b\u0010M\u001a\u00020GH\u0016J\b\u0010N\u001a\u00020\fH\u0016J\b\u0010O\u001a\u00020GH\u0016J\b\u0010P\u001a\u00020GH\u0016J\b\u0010Q\u001a\u00020GH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00108\u0012X\u0093D\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000e\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000eR\u0014\u0010)\u001a\u00020*X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u000eR\u0014\u0010/\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000eR\u0014\u00101\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u000eR\u0014\u00103\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u000eR\u001a\u00105\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0012\"\u0004\b7\u0010\u0014R\u001a\u00108\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010,\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0012\"\u0004\b>\u0010\u0014R\u001a\u0010?\u001a\u00020*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010,\"\u0004\bA\u0010;\u00a8\u0006R"}, d2={"Lcom/example/ctrl891/service/BatteryService;", "", "messageService", "Lcom/example/ctrl891/service/MessageService;", "(Lcom/example/ctrl891/service/MessageService;)V", "batteryInfo", "Lcom/example/ctrl891/service/BatteryInfo;", "getBatteryInfo", "()Lcom/example/ctrl891/service/BatteryInfo;", "setBatteryInfo", "(Lcom/example/ctrl891/service/BatteryInfo;)V", "capacityTotalDefault", "", "getCapacityTotalDefault", "()I", "connected", "", "getConnected", "()Z", "setConnected", "(Z)V", "feature_battery", "Ljava/lang/Boolean;", "hourInMs", "", "getHourInMs", "()F", "logger", "Lmu/KLogger;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "path", "", "getPath", "()Ljava/lang/String;", "power", "getPower", "setPower", "(I)V", "rxConsumption", "getRxConsumption", "sleepTime", "", "getSleepTime", "()J", "txConsumption", "getTxConsumption", "txConsumption_10", "getTxConsumption_10", "txConsumption_100", "getTxConsumption_100", "txConsumption_60", "getTxConsumption_60", "txEnabled", "getTxEnabled", "setTxEnabled", "txStartTime", "getTxStartTime", "setTxStartTime", "(J)V", "txState", "getTxState", "setTxState", "upStartTime", "getUpStartTime", "setUpStartTime", "formatTime", "s", "initBattery", "capacityTotal", "loadState", "", "processEvent", "cat", "Lcom/example/ctrl891/model/CatCommand;", "reset", "sendState", "start", "txConsumptionSsb", "txStarted", "txStopped", "writeState", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nBatteryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatteryService.kt\ncom/example/ctrl891/service/BatteryService\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,237:1\n113#2:238\n96#3:239\n*S KotlinDebug\n*F\n+ 1 BatteryService.kt\ncom/example/ctrl891/service/BatteryService\n*L\n192#1:238\n206#1:239\n*E\n"})
public class BatteryService {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final KLogger logger;
    private long upStartTime;
    private boolean txEnabled;
    private long txStartTime;
    private final int capacityTotalDefault;
    @NotNull
    private final String path;
    private final int rxConsumption;
    private final int txConsumption;
    private final int txConsumption_10;
    private final int txConsumption_60;
    private final int txConsumption_100;
    @NotNull
    private BatteryInfo batteryInfo;
    private boolean txState;
    private final float hourInMs;
    private boolean connected;
    private int power;
    private final long sleepTime;
    @Value(value="${feature.battery:false}")
    @Nullable
    private final Boolean feature_battery;

    public BatteryService(@NotNull MessageService messageService) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        this.messageService = messageService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.capacityTotalDefault = 6000;
        this.path = "battery-info.json";
        this.rxConsumption = 1000;
        this.txConsumption = 4200;
        this.txConsumption_10 = 4700;
        this.txConsumption_60 = 6000;
        this.txConsumption_100 = 8000;
        this.batteryInfo = this.initBattery(this.getCapacityTotalDefault());
        this.hourInMs = 3600000.0f;
        this.power = 5;
        this.sleepTime = 10000L;
        this.feature_battery = false;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    public long getUpStartTime() {
        return this.upStartTime;
    }

    public void setUpStartTime(long l) {
        this.upStartTime = l;
    }

    public boolean getTxEnabled() {
        return this.txEnabled;
    }

    public void setTxEnabled(boolean bl) {
        this.txEnabled = bl;
    }

    public long getTxStartTime() {
        return this.txStartTime;
    }

    public void setTxStartTime(long l) {
        this.txStartTime = l;
    }

    public int getCapacityTotalDefault() {
        return this.capacityTotalDefault;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public int getRxConsumption() {
        return this.rxConsumption;
    }

    public int getTxConsumption() {
        return this.txConsumption;
    }

    public int getTxConsumption_10() {
        return this.txConsumption_10;
    }

    public int getTxConsumption_60() {
        return this.txConsumption_60;
    }

    public int getTxConsumption_100() {
        return this.txConsumption_100;
    }

    public int txConsumptionSsb() {
        return 4000 + 40 * this.getPower();
    }

    @NotNull
    public BatteryInfo initBattery(int capacityTotal) {
        long l = System.currentTimeMillis();
        return new BatteryInfo(l, capacityTotal, 0, 0, 1L, 1L, null, null, null, 448, null);
    }

    @NotNull
    public BatteryInfo getBatteryInfo() {
        return this.batteryInfo;
    }

    public void setBatteryInfo(@NotNull BatteryInfo batteryInfo) {
        Intrinsics.checkNotNullParameter((Object)batteryInfo, (String)"<set-?>");
        this.batteryInfo = batteryInfo;
    }

    public boolean getTxState() {
        return this.txState;
    }

    public void setTxState(boolean bl) {
        this.txState = bl;
    }

    public float getHourInMs() {
        return this.hourInMs;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int n) {
        this.power = n;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void start() {
        if (this.feature_battery == null || !this.feature_battery.booleanValue()) {
            return;
        }
        this.loadState();
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"BatteryService", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    @NotNull
    public String formatTime(long s) {
        String string = "%d:%02d";
        Object[] objectArray = new Object[]{s / (long)3600, s % (long)3600 / (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public void processEvent(@NotNull CatCommand cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        if (Intrinsics.areEqual((Object)cat.getCmd(), (Object)"RADIO_INFO_LED_TX") && cat instanceof BooleanValue) {
            Boolean tx = ((BooleanValue)cat).getEnabled();
            if (Intrinsics.areEqual((Object)tx, (Object)true)) {
                this.txStarted();
            } else {
                if (this.getTxStartTime() == 0L) {
                    return;
                }
                this.txStopped();
            }
        }
        if (Intrinsics.areEqual((Object)cat.getCmd(), (Object)"CAT_STATE") && cat instanceof CAT_STATE) {
            this.setConnected(((CAT_STATE)cat).getIdentified());
            this.setTxState(false);
        }
        if (Intrinsics.areEqual((Object)cat.getCmd(), (Object)"POWER_CONTROL") && cat instanceof IntValue) {
            this.setPower(((IntValue)cat).getValue());
        }
    }

    public void txStarted() {
        this.setTxStartTime(System.currentTimeMillis());
        this.setTxState(true);
    }

    public void txStopped() {
        long diff = System.currentTimeMillis() - this.getTxStartTime();
        BatteryInfo batteryInfo = this.getBatteryInfo();
        batteryInfo.setUptimeTx(batteryInfo.getUptimeTx() + diff);
        int txAdjusted = this.txConsumptionSsb();
        int extra = txAdjusted - this.getRxConsumption();
        BatteryInfo batteryInfo2 = this.getBatteryInfo();
        batteryInfo2.setCapacityUsedTx(batteryInfo2.getCapacityUsedTx() + (int)((float)diff / this.getHourInMs() * (float)extra));
        this.setTxState(false);
        this.sendState();
    }

    public void writeState() {
        BatteryInfo b = this.getBatteryInfo();
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)writeState.json.1.INSTANCE), (int)1, null);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)BatteryInfo.Companion.serializer(), (Object)b);
        File file = new File(this.getPath());
        FilesKt.writeText$default((File)file, (String)json2, null, (int)2, null);
    }

    public void loadState() {
        try {
            File file = new File(this.getPath());
            if (!file.exists()) {
                this.writeState();
            }
            this.logger.info("read battery json " + file.getAbsolutePath());
            String text = FilesKt.readText$default((File)file, null, (int)1, null);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this.setBatteryInfo((BatteryInfo)this_$iv.decodeFromString((DeserializationStrategy)BatteryInfo.Companion.serializer(), text));
        }
        catch (Exception e) {
            this.logger.warn("battery json load error");
        }
    }

    @NotNull
    public BatteryInfo reset(int capacityTotal) {
        this.setBatteryInfo(this.initBattery(capacityTotal));
        this.sendState();
        return this.getBatteryInfo();
    }

    public static /* synthetic */ BatteryInfo reset$default(BatteryService batteryService, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reset");
        }
        if ((n2 & 1) != 0) {
            n = batteryService.getCapacityTotalDefault();
        }
        return batteryService.reset(n);
    }

    public void sendState() {
        BatteryInfo $this$sendState_u24lambda_u240 = this.getBatteryInfo();
        boolean bl = false;
        long l = $this$sendState_u24lambda_u240.getTimestamp();
        int n = $this$sendState_u24lambda_u240.getCapacityTotal();
        int n2 = $this$sendState_u24lambda_u240.getCapacityUsed();
        long l2 = $this$sendState_u24lambda_u240.getUptime();
        long l3 = $this$sendState_u24lambda_u240.getUptimeTx();
        Integer n3 = $this$sendState_u24lambda_u240.getPercentageRemaining();
        String string = $this$sendState_u24lambda_u240.getUptimeString();
        String string2 = $this$sendState_u24lambda_u240.getUptimeTxString();
        int n4 = $this$sendState_u24lambda_u240.getCapacityUsedTx();
        this.getMessageService().addCatMessage((CatCommand)new CAT_BATTERY_INFO(null, l, n, n2, Integer.valueOf(n4), l2, l3, n3, string, string2, 1, null));
    }
}

