/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.AUDIO_IN_STATE;
import com.example.ctrl891.model.AUDIO_OUT_STATE;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.service.AudioStatsCallback;
import com.example.ctrl891.service.AudioSystem;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.util.WaveHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0004J\u0018\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u0006J\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u0004\u0018\u00010CJ\u0006\u0010D\u001a\u00020AJ\b\u0010E\u001a\u0004\u0018\u00010FJ\u0010\u0010G\u001a\u0004\u0018\u00010C2\u0006\u0010H\u001a\u00020=J\u0010\u0010I\u001a\u0004\u0018\u00010F2\u0006\u0010H\u001a\u00020=J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KH\u0002J\b\u0010M\u001a\u0004\u0018\u00010=J\u000e\u0010N\u001a\u00020:2\u0006\u0010O\u001a\u00020CJ\u000e\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u00020\u0004J\u0018\u0010R\u001a\u00020\u00042\u0006\u0010O\u001a\u00020F2\b\b\u0002\u0010S\u001a\u00020\u001fJ\u0018\u0010T\u001a\u00020:2\u0006\u0010O\u001a\u00020C2\b\b\u0002\u0010S\u001a\u00020\u001fJ\u0018\u0010U\u001a\u00020:2\u0006\u0010O\u001a\u00020F2\b\b\u0002\u0010S\u001a\u00020\u001fJ\u0006\u0010V\u001a\u00020:J\u000e\u0010W\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010X\u001a\u00020:2\u0006\u0010Q\u001a\u00020\u0004R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u0014\u00101\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001bR\u001a\u00103\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001b\u00a8\u0006Y"}, d2={"Lcom/example/ctrl891/service/AudioSystem;", "", "blockingQueue", "Ljava/util/concurrent/BlockingQueue;", "", "audioInDeviceName", "", "audioInDeviceDescription", "audioOutDeviceName", "audioOutDeviceDescription", "audioStatsCallback", "Lcom/example/ctrl891/service/AudioStatsCallback;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "(Ljava/util/concurrent/BlockingQueue;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/example/ctrl891/service/AudioStatsCallback;Lcom/example/ctrl891/service/MessageService;)V", "getAudioInDeviceDescription", "()Ljava/lang/String;", "getAudioInDeviceName", "getAudioOutDeviceDescription", "getAudioOutDeviceName", "getAudioStatsCallback", "()Lcom/example/ctrl891/service/AudioStatsCallback;", "getBlockingQueue", "()Ljava/util/concurrent/BlockingQueue;", "bufferSize", "", "getBufferSize", "()I", "bufferSizeRatio", "getBufferSizeRatio", "calcStats", "", "getCalcStats", "()Z", "logger", "Lmu/KLogger;", "megabytes", "getMegabytes", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "playbackThread", "Ljava/lang/Thread;", "getPlaybackThread", "()Ljava/lang/Thread;", "setPlaybackThread", "(Ljava/lang/Thread;)V", "recordThread", "getRecordThread", "setRecordThread", "sampleRate", "getSampleRate", "stopRequested", "getStopRequested", "setStopRequested", "(Z)V", "wavSize", "getWavSize", "calculate", "", "byteArray", "getDevice", "Ljavax/sound/sampled/Mixer$Info;", "audioDeviceName", "audioDeviceDescription", "getPlaybackAudioFormat", "Ljavax/sound/sampled/AudioFormat;", "getPlaybackLine", "Ljavax/sound/sampled/SourceDataLine;", "getRecordAudioFormat", "getRecordLine", "Ljavax/sound/sampled/TargetDataLine;", "getSourceLine", "info", "getTargetLine", "linearToDecibel", "", "value", "listDevices", "playback", "line", "processData", "data", "record", "doWriteWav", "runPlaybackThread", "runRecordThread", "stop", "writeChunk", "writeFile", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nAudioSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSystem.kt\ncom/example/ctrl891/service/AudioSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,379:1\n11085#2:380\n11420#2,3:381\n*S KotlinDebug\n*F\n+ 1 AudioSystem.kt\ncom/example/ctrl891/service/AudioSystem\n*L\n215#1:380\n215#1:381,3\n*E\n"})
public final class AudioSystem {
    @NotNull
    private final BlockingQueue<byte[]> blockingQueue;
    @NotNull
    private final String audioInDeviceName;
    @NotNull
    private final String audioInDeviceDescription;
    @NotNull
    private final String audioOutDeviceName;
    @NotNull
    private final String audioOutDeviceDescription;
    @NotNull
    private final AudioStatsCallback audioStatsCallback;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final KLogger logger;
    private boolean stopRequested;
    private final int megabytes;
    private final int sampleRate;
    private final int wavSize;
    @Nullable
    private Thread recordThread;
    @Nullable
    private Thread playbackThread;
    private final int bufferSizeRatio;
    private final int bufferSize;
    private final boolean calcStats;

    public AudioSystem(@NotNull BlockingQueue<byte[]> blockingQueue, @NotNull String audioInDeviceName, @NotNull String audioInDeviceDescription, @NotNull String audioOutDeviceName, @NotNull String audioOutDeviceDescription, @NotNull AudioStatsCallback audioStatsCallback, @NotNull MessageService messageService) {
        Intrinsics.checkNotNullParameter(blockingQueue, (String)"blockingQueue");
        Intrinsics.checkNotNullParameter((Object)audioInDeviceName, (String)"audioInDeviceName");
        Intrinsics.checkNotNullParameter((Object)audioInDeviceDescription, (String)"audioInDeviceDescription");
        Intrinsics.checkNotNullParameter((Object)audioOutDeviceName, (String)"audioOutDeviceName");
        Intrinsics.checkNotNullParameter((Object)audioOutDeviceDescription, (String)"audioOutDeviceDescription");
        Intrinsics.checkNotNullParameter((Object)audioStatsCallback, (String)"audioStatsCallback");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        this.blockingQueue = blockingQueue;
        this.audioInDeviceName = audioInDeviceName;
        this.audioInDeviceDescription = audioInDeviceDescription;
        this.audioOutDeviceName = audioOutDeviceName;
        this.audioOutDeviceDescription = audioOutDeviceDescription;
        this.audioStatsCallback = audioStatsCallback;
        this.messageService = messageService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.megabytes = 0x100000;
        this.sampleRate = 44100;
        this.wavSize = 50 * this.megabytes;
        this.bufferSizeRatio = 5;
        this.bufferSize = 16000;
    }

    @NotNull
    public final BlockingQueue<byte[]> getBlockingQueue() {
        return this.blockingQueue;
    }

    @NotNull
    public final String getAudioInDeviceName() {
        return this.audioInDeviceName;
    }

    @NotNull
    public final String getAudioInDeviceDescription() {
        return this.audioInDeviceDescription;
    }

    @NotNull
    public final String getAudioOutDeviceName() {
        return this.audioOutDeviceName;
    }

    @NotNull
    public final String getAudioOutDeviceDescription() {
        return this.audioOutDeviceDescription;
    }

    @NotNull
    public final AudioStatsCallback getAudioStatsCallback() {
        return this.audioStatsCallback;
    }

    @NotNull
    public final MessageService getMessageService() {
        return this.messageService;
    }

    public final boolean getStopRequested() {
        return this.stopRequested;
    }

    public final void setStopRequested(boolean bl) {
        this.stopRequested = bl;
    }

    @Nullable
    public final TargetDataLine getRecordLine() {
        Mixer.Info d = this.getDevice(this.audioInDeviceName, this.audioInDeviceDescription);
        if (d != null) {
            TargetDataLine l = this.getTargetLine(d);
            this.logger.info("line: " + l);
            if (l == null) {
                this.logger.warn("line not found");
            }
            return l;
        }
        this.logger.warn("device not found");
        return null;
    }

    @Nullable
    public final SourceDataLine getPlaybackLine() {
        Mixer.Info d = this.getDevice(this.audioOutDeviceName, this.audioOutDeviceDescription);
        if (d != null) {
            SourceDataLine l = this.getSourceLine(d);
            this.logger.info("line: " + l);
            if (l == null) {
                this.logger.warn("line not found");
            }
            return l;
        }
        this.logger.warn("device not found");
        return null;
    }

    public final void stop() {
        this.stopRequested = false;
    }

    public final int getMegabytes() {
        return this.megabytes;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getWavSize() {
        return this.wavSize;
    }

    @Nullable
    public final Thread getRecordThread() {
        return this.recordThread;
    }

    public final void setRecordThread(@Nullable Thread thread) {
        this.recordThread = thread;
    }

    @Nullable
    public final Thread getPlaybackThread() {
        return this.playbackThread;
    }

    public final void setPlaybackThread(@Nullable Thread thread) {
        this.playbackThread = thread;
    }

    public final void runRecordThread(@NotNull TargetDataLine line, boolean doWriteWav) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.stopRequested = true;
        this.logger.info("runRecordThread: " + line);
        this.recordThread = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"AudioRecord", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public static /* synthetic */ void runRecordThread$default(AudioSystem audioSystem, TargetDataLine targetDataLine, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        audioSystem.runRecordThread(targetDataLine, bl);
    }

    public final void runPlaybackThread(@NotNull SourceDataLine line, boolean doWriteWav) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.stopRequested = true;
        this.logger.info("runPlaybackThread: " + line);
        this.playbackThread = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"AudioPlayback", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public static /* synthetic */ void runPlaybackThread$default(AudioSystem audioSystem, SourceDataLine sourceDataLine, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        audioSystem.runPlaybackThread(sourceDataLine, bl);
    }

    public final int getBufferSizeRatio() {
        return this.bufferSizeRatio;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final boolean getCalcStats() {
        return this.calcStats;
    }

    @NotNull
    public final byte[] record(@NotNull TargetDataLine line, boolean doWriteWav) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        AudioFormat format = this.getRecordAudioFormat();
        this.logger.info("open line. buffer size = " + line.getBufferSize() + " | line level = " + line.getLevel());
        line.open(format, this.bufferSize);
        this.logger.info("bufferSize=" + line.getBufferSize());
        this.logger.info("start line record");
        line.start();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int numBytesRead = 0;
        byte[] data = new byte[line.getBufferSize() / this.bufferSizeRatio];
        this.logger.info("bufferSizeRatio = " + this.bufferSizeRatio);
        this.logger.info("read buffer size = " + data.length);
        this.messageService.addCatMessage((CatCommand)new AUDIO_IN_STATE(null, this.audioInDeviceName, true, 1, null));
        int count = 0;
        int logCount = 50;
        int numBytesReadOld = 0;
        int total = 0;
        while (this.stopRequested) {
            numBytesRead = line.read(data, 0, data.length);
            if (count % logCount == 0) {
                this.logger.info("read: " + numBytesRead + " / " + total);
            }
            if (numBytesReadOld != numBytesRead) {
                this.logger.info("new buffer size read bytes : " + numBytesRead);
                numBytesReadOld = numBytesRead;
            }
            byte[] byArray = data;
            int n = 0;
            byte[] data2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)numBytesRead);
            this.processData(data2);
            if (doWriteWav) {
                out.write(data2);
            }
            total += numBytesRead;
            ++count;
        }
        this.logger.info("stop line");
        line.stop();
        this.logger.info("close line");
        line.close();
        this.messageService.addCatMessage((CatCommand)new AUDIO_IN_STATE(null, this.audioInDeviceName, false, 1, null));
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] record$default(AudioSystem audioSystem, TargetDataLine targetDataLine, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audioSystem.record(targetDataLine, bl);
    }

    public final void playback(@NotNull SourceDataLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        AudioFormat format = this.getPlaybackAudioFormat();
        this.logger.info("open line. buffer size = " + line.getBufferSize() + " | line level = " + line.getLevel());
        line.open(format, this.bufferSize);
        this.logger.info("bufferSize=" + line.getBufferSize());
        this.logger.info("start line playback");
        line.start();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean numBytesRead = false;
        byte[] data = new byte[line.getBufferSize() / this.bufferSizeRatio];
        this.logger.info("bufferSizeRatio = " + this.bufferSizeRatio);
        this.logger.info("read buffer size = " + data.length);
        this.messageService.addCatMessage((CatCommand)new AUDIO_OUT_STATE(null, this.audioOutDeviceName, true, 1, null));
    }

    public final void processData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.writeChunk(data);
        if (this.calcStats) {
            this.calculate(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void calculate(@NotNull byte[] byteArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        ShortBuffer shortBuffer = ByteBuffer.wrap(byteArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"asShortBuffer(...)");
        ShortBuffer shortBuf = shortBuffer;
        short[] array = new short[shortBuf.remaining()];
        shortBuf.get(array);
        boolean sum = false;
        short[] $this$map$iv = array;
        boolean $i$f$map = false;
        short[] sArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_16 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)Math.pow((float)it, 2)));
        }
        List sq = (List)destination$iv$iv;
        float sqs = CollectionsKt.sumOfFloat((Iterable)sq) / (float)sq.size();
        float sqr = (float)Math.sqrt(sqs);
        int n2 = (int)sqr;
        this.logger.info("sqr " + n2);
        this.audioStatsCallback.sendStats(n2);
    }

    private final double linearToDecibel(double value) {
        return 20.0 * Math.log10(value);
    }

    public final void writeChunk(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.blockingQueue.put(byteArray);
    }

    @Nullable
    public final Mixer.Info getDevice(@NotNull String audioDeviceName, @NotNull String audioDeviceDescription) {
        Intrinsics.checkNotNullParameter((Object)audioDeviceName, (String)"audioDeviceName");
        Intrinsics.checkNotNullParameter((Object)audioDeviceDescription, (String)"audioDeviceDescription");
        this.logger.info("search device " + audioDeviceName + " / " + audioDeviceDescription);
        Mixer.Info[] infos = javax.sound.sampled.AudioSystem.getMixerInfo();
        boolean count = false;
        for (Mixer.Info info : infos) {
            String string = info.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence charSequence = string;
            String string2 = audioDeviceName;
            if (string2 == null) {
                string2 = "";
            }
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                // empty if block
            }
            if (!Intrinsics.areEqual((Object)info.getName(), (Object)audioDeviceName) || !Intrinsics.areEqual((Object)info.getDescription(), (Object)audioDeviceDescription)) continue;
            this.logger.info("--------------------------------");
            this.logger.info("### found device " + audioDeviceName + " / " + audioDeviceDescription);
            return info;
        }
        this.logger.warn("device not found: " + audioDeviceName + " / " + audioDeviceDescription);
        return null;
    }

    @Nullable
    public final Mixer.Info listDevices() {
        this.logger.info("#########################");
        this.logger.info("List all audio mixers");
        Mixer.Info[] infos = javax.sound.sampled.AudioSystem.getMixerInfo();
        int count = 0;
        for (Mixer.Info info : infos) {
            this.logger.info("[" + count++ + "] name=" + info.getName() + ", description=" + info.getDescription());
        }
        return null;
    }

    @NotNull
    public final AudioFormat getRecordAudioFormat() {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    @NotNull
    public final AudioFormat getPlaybackAudioFormat() {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    @Nullable
    public final TargetDataLine getTargetLine(@NotNull Mixer.Info info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Mixer m = javax.sound.sampled.AudioSystem.getMixer(info);
        Line.Info[] infoArray = m.getTargetLineInfo();
        Intrinsics.checkNotNullExpressionValue((Object)infoArray, (String)"getTargetLineInfo(...)");
        Line.Info line = (Line.Info)ArraysKt.first((Object[])infoArray);
        if (line != null) {
            this.logger.info("linein " + line);
            this.logger.info("linein javaClass " + line.getClass());
            this.logger.info("linein lineClass " + line.getLineClass());
            Line line2 = m.getLine(line);
            Intrinsics.checkNotNull((Object)line2, (String)"null cannot be cast to non-null type javax.sound.sampled.TargetDataLine");
            TargetDataLine l2 = (TargetDataLine)line2;
            return l2;
        }
        this.logger.error("No Target Line found");
        return null;
    }

    @Nullable
    public final SourceDataLine getSourceLine(@NotNull Mixer.Info info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Mixer m = javax.sound.sampled.AudioSystem.getMixer(info);
        Line.Info[] infoArray = m.getSourceLineInfo();
        Intrinsics.checkNotNullExpressionValue((Object)infoArray, (String)"getSourceLineInfo(...)");
        Line.Info line = (Line.Info)ArraysKt.first((Object[])infoArray);
        if (line != null) {
            this.logger.info("linein " + line);
            this.logger.info("linein javaClass " + line.getClass());
            this.logger.info("linein lineClass " + line.getLineClass());
            Line line2 = m.getLine(line);
            Intrinsics.checkNotNull((Object)line2, (String)"null cannot be cast to non-null type javax.sound.sampled.SourceDataLine");
            SourceDataLine l2 = (SourceDataLine)line2;
            return l2;
        }
        this.logger.error("No Source Line found");
        return null;
    }

    public final void writeFile(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        File dir = new File("./audio");
        dir.mkdirs();
        String fn = "record_" + System.currentTimeMillis() + ".wav";
        this.logger.info("write wav data bytes " + data.length + " - " + fn);
        AudioSystem.writeFile$writeWav((File)dir, (String)fn, (AudioSystem)this, (byte[])data);
    }

    private static final void writeFile$writeWaveHeader(AudioSystem this$0, OutputStream os, int numBytes) {
        new WaveHeader(1, 1, this$0.sampleRate, 16, numBytes).write(os);
    }

    private static final void writeFile$writeWav(File dir, String fn, AudioSystem this$0, byte[] data) {
        File wavFile = new File(dir, fn);
        FileOutputStream os = new FileOutputStream(wavFile);
        AudioSystem.writeFile$writeWaveHeader((AudioSystem)this$0, (OutputStream)os, (int)(50 * this$0.megabytes));
        os.write(data);
        os.close();
    }
}

