/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.service;

import com.example.ctrl891.model.AudioFile;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.service.AudioPublisher;
import com.example.ctrl891.service.AudioService;
import com.example.ctrl891.service.AudioStatsCallback;
import com.example.ctrl891.service.AudioSystem;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.WavPlayer;
import com.example.ctrl891.util.WaveHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Sinks;

@Service
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\b\u00104\u001a\u000202H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0016J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u001bH\u0016J\b\u0010<\u001a\u000202H\u0016J\u0010\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020\rH\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020@H\u0016J\b\u0010B\u001a\u000202H\u0016J\b\u0010C\u001a\u000202H\u0016J\u0010\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020\u0013H\u0016J\u0018\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\r8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010)8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001d\u00a8\u0006J"}, d2={"Lcom/example/ctrl891/service/AudioService;", "Lcom/example/ctrl891/service/AudioStatsCallback;", "Lcom/example/ctrl891/service/AudioPublisher;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "(Lcom/example/ctrl891/service/MessageService;)V", "audio", "Lcom/example/ctrl891/service/AudioSystem;", "getAudio", "()Lcom/example/ctrl891/service/AudioSystem;", "setAudio", "(Lcom/example/ctrl891/service/AudioSystem;)V", "audioInDeviceDescription", "", "audioInDeviceName", "audioOutDeviceDescription", "audioOutDeviceName", "blockingQueue", "Ljava/util/concurrent/BlockingQueue;", "", "getBlockingQueue", "()Ljava/util/concurrent/BlockingQueue;", "setBlockingQueue", "(Ljava/util/concurrent/BlockingQueue;)V", "logger", "Lmu/KLogger;", "maxQueueSize", "", "getMaxQueueSize", "()I", "megabytes", "getMegabytes", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "sampleRate", "getSampleRate", "sender", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "getSender", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "sink", "Lreactor/core/publisher/Sinks$Many;", "wavPlayer", "Lcom/example/ctrl891/service/WavPlayer;", "getWavPlayer", "()Lcom/example/ctrl891/service/WavPlayer;", "wavSize", "getWavSize", "getWaveInit", "init", "", "initAudioSystem", "listDevices", "listWav", "", "Lcom/example/ctrl891/model/AudioFile;", "publish", "t", "sendStats", "number", "startForward", "startPlayWav", "filename", "startPlayback", "", "startRecord", "stopPlayWav", "stopRecord", "writeWav", "data", "writeWaveHeader", "os", "Ljava/io/OutputStream;", "numBytes", "ctrl891"})
public class AudioService
implements AudioStatsCallback,
AudioPublisher {
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final KLogger logger;
    private final int maxQueueSize;
    @NotNull
    private BlockingQueue<byte[]> blockingQueue;
    @Value(value="${audio.in.deviceName}")
    @Nullable
    private final String audioInDeviceName;
    @Value(value="${audio.in.deviceDescription}")
    @Nullable
    private final String audioInDeviceDescription;
    @Value(value="${audio.out.deviceName}")
    @Nullable
    private final String audioOutDeviceName;
    @Value(value="${audio.out.deviceDescription}")
    @Nullable
    private final String audioOutDeviceDescription;
    @Nullable
    private AudioSystem audio;
    @NotNull
    private final WavPlayer wavPlayer;
    @NotNull
    private final MutableSharedFlow<byte[]> sender;
    @Autowired
    @Nullable
    private Sinks.Many<byte[]> sink;
    private final int megabytes;
    private final int sampleRate;
    private final int wavSize;

    public AudioService(@NotNull MessageService messageService) {
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        this.messageService = messageService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.maxQueueSize = 100;
        this.blockingQueue = new LinkedBlockingDeque(this.getMaxQueueSize());
        this.wavPlayer = new WavPlayer((AudioPublisher)this);
        this.sender = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.megabytes = 0x100000;
        this.sampleRate = 44100;
        this.wavSize = 50 * this.getMegabytes();
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @NotNull
    public BlockingQueue<byte[]> getBlockingQueue() {
        return this.blockingQueue;
    }

    public void setBlockingQueue(@NotNull BlockingQueue<byte[]> blockingQueue) {
        Intrinsics.checkNotNullParameter(blockingQueue, (String)"<set-?>");
        this.blockingQueue = blockingQueue;
    }

    @Nullable
    public AudioSystem getAudio() {
        return this.audio;
    }

    public void setAudio(@Nullable AudioSystem audioSystem) {
        this.audio = audioSystem;
    }

    @NotNull
    public WavPlayer getWavPlayer() {
        return this.wavPlayer;
    }

    @NotNull
    public MutableSharedFlow<byte[]> getSender() {
        return this.sender;
    }

    public int getMegabytes() {
        return this.megabytes;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getWavSize() {
        return this.wavSize;
    }

    public void init() {
        this.logger.info("init");
        this.initAudioSystem();
        this.startForward();
    }

    public void startForward() {
        this.logger.info("start forward");
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)"AudioForward", (int)0, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */), (int)20, null);
    }

    public void listDevices() {
        block0: {
            AudioSystem audioSystem = this.getAudio();
            if (audioSystem == null) break block0;
            audioSystem.listDevices();
        }
    }

    public void initAudioSystem() {
        if (this.getAudio() == null) {
            String string;
            String string2;
            String string3;
            BlockingQueue blockingQueue = this.getBlockingQueue();
            String string4 = this.audioInDeviceName;
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = this.audioInDeviceDescription) == null) {
                string3 = "";
            }
            if ((string2 = this.audioOutDeviceName) == null) {
                string2 = "";
            }
            if ((string = this.audioOutDeviceDescription) == null) {
                string = "";
            }
            this.setAudio(new AudioSystem(blockingQueue, string4, string3, string2, string, (AudioStatsCallback)this, this.getMessageService()));
        }
    }

    public boolean startRecord() {
        TargetDataLine targetDataLine;
        this.initAudioSystem();
        AudioSystem audioSystem = this.getAudio();
        TargetDataLine targetDataLine2 = targetDataLine = audioSystem != null ? audioSystem.getRecordLine() : null;
        if (targetDataLine != null) {
            AudioSystem audioSystem2 = this.getAudio();
            if (audioSystem2 != null) {
                AudioSystem.runRecordThread$default((AudioSystem)audioSystem2, (TargetDataLine)targetDataLine, (boolean)false, (int)2, null);
            }
            return true;
        }
        return false;
    }

    public void stopRecord() {
        block0: {
            AudioSystem audioSystem = this.getAudio();
            if (audioSystem == null) break block0;
            audioSystem.stop();
        }
    }

    public boolean startPlayback() {
        SourceDataLine sourceDataLine;
        this.initAudioSystem();
        AudioSystem audioSystem = this.getAudio();
        SourceDataLine sourceDataLine2 = sourceDataLine = audioSystem != null ? audioSystem.getPlaybackLine() : null;
        if (sourceDataLine != null) {
            AudioSystem audioSystem2 = this.getAudio();
            if (audioSystem2 != null) {
                AudioSystem.runPlaybackThread$default((AudioSystem)audioSystem2, (SourceDataLine)sourceDataLine, (boolean)false, (int)2, null);
            }
            return true;
        }
        return false;
    }

    public void publish(@NotNull byte[] t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Sinks.Many many = this.sink;
        Intrinsics.checkNotNull((Object)many);
        many.tryEmitNext((Object)t);
    }

    public void startPlayWav(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (this.getWavPlayer().isPlaying()) {
            this.getWavPlayer().stopPublishWaveFile();
        }
        this.getWavPlayer().startPublishWaveFile(filename);
    }

    public void stopPlayWav() {
        this.getWavPlayer().stopPublishWaveFile();
    }

    @NotNull
    public List<AudioFile> listWav() {
        return this.getWavPlayer().listWave();
    }

    public void sendStats(int number) {
        IntValue x1 = new IntValue("AUDIO_RMS", number);
        this.getMessageService().addCatMessage((CatCommand)x1);
    }

    @NotNull
    public byte[] getWaveInit() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeWaveHeader((OutputStream)os, this.getWavSize());
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public void writeWav(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        File wavFile = new File("audio5.wav");
        FileOutputStream os = new FileOutputStream(wavFile);
        this.writeWaveHeader((OutputStream)os, 50 * this.getMegabytes());
        os.write(data);
        os.close();
    }

    public void writeWaveHeader(@NotNull OutputStream os, int numBytes) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        new WaveHeader(1, 1, this.getSampleRate(), 16, numBytes).write(os);
    }
}

