/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.generator;

import com.example.ctrl891.generator.BandplanParserService;
import com.example.ctrl891.model.FE;
import com.example.ctrl891.model.IaruBand;
import com.example.ctrl891.model.IaruEntry;
import com.github.doyaaaaaken.kotlincsv.client.CsvReader;
import com.github.doyaaaaaken.kotlincsv.dsl.CsvReaderDslKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/example/ctrl891/generator/BandplanParserService;", "", "()V", "logger", "Lmu/KLogger;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "generateBna", "", "generateIaru", "nr", "", "parseBna", "", "Lcom/example/ctrl891/model/FE;", "html", "", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nBandplanParserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandplanParserService.kt\ncom/example/ctrl891/generator/BandplanParserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,146:1\n766#2:147\n857#2,2:148\n1549#2:150\n1620#2,3:151\n1855#2,2:154\n766#2:156\n857#2,2:157\n1549#2:160\n1620#2,3:161\n1855#2,2:164\n1855#2,2:166\n113#3:159\n113#3:168\n*S KotlinDebug\n*F\n+ 1 BandplanParserService.kt\ncom/example/ctrl891/generator/BandplanParserService\n*L\n31#1:147\n31#1:148,2\n32#1:150\n32#1:151,3\n44#1:154,2\n47#1:156\n47#1:157,2\n61#1:160\n61#1:161,3\n92#1:164,2\n100#1:166,2\n49#1:159\n133#1:168\n*E\n"})
public class BandplanParserService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Autowired
    private ResourceLoader resourceLoader;

    /*
     * WARNING - void declaration
     */
    public void generateBna() {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Iterator $this$mapTo$iv$iv;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv2;
        ResourceLoader resourceLoader = this.resourceLoader;
        if (resourceLoader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceLoader");
            resourceLoader = null;
        }
        File file = resourceLoader.getResource("classpath:data/Frequenzplan Deutschland.html").getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        String html = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        Iterable $this$filter$iv = this.parseBna(html);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            FE it = (FE)element$iv$iv2;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getFreq(), (CharSequence)"kHz", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List l = (List)destination$iv$iv;
        Iterable $this$map$iv = l;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            void var14_32;
            void it;
            Object item$iv$iv = element$iv$iv2.next();
            FE bl = (FE)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            try {
                String[] stringArray = new String[]{"-"};
                List list = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)it.getFreq(), (String)" kHz", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                FE.copy$default((FE)it, null, null, null, null, null, (Double)Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)list.get(0)))).toString()), (Double)Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)list.get(1)))).toString()), (int)31, null);
                this.logger.info("processed " + it.getFreq());
                var14_32 = it;
            }
            catch (Exception ex) {
                this.logger.error("err", (Throwable)ex);
                var14_32 = it;
            }
            collection.add(var14_32);
        }
        List l2 = (List)destination$iv$iv2;
        this.logger.info("# " + l2.size());
        Iterable $this$forEach$iv = l2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            FE it = (FE)element$iv2;
            boolean bl = false;
            this.logger.info("" + it);
        }
        Iterable $this$filter$iv2 = l2;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            FE it = (FE)element$iv$iv3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"RUNDFUNKDIENST")) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List l3 = (List)destination$iv$iv3;
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(FE.Companion.serializer()), (Object)l3);
        FilesKt.writeText$default((File)new File("bandplan_all_data.json"), (String)json2, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<FE> parseBna(@NotNull String html) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.logger.info("parse " + html.length() + " bytes");
        Document document = Jsoup.parse((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document doc = document;
        Elements elements = doc.select("body > div > div > div > table > tbody > tr  ");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"select(...)");
        Elements items = elements;
        Iterable $this$map$iv = (Iterable)items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FE fE;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                void item;
                void $this$parseBna_u24lambda_u245_u24lambda_u244 = item;
                boolean bl2 = false;
                String string = $this$parseBna_u24lambda_u245_u24lambda_u244.select("td:first-child").text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                String string2 = StringsKt.replace$default((String)string, (String)",", (String)".", (boolean)false, (int)4, null);
                String string3 = $this$parseBna_u24lambda_u245_u24lambda_u244.select("td:nth-child(2)").text();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text(...)");
                String string4 = $this$parseBna_u24lambda_u245_u24lambda_u244.select("td:nth-child(3)").text();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text(...)");
                String string5 = $this$parseBna_u24lambda_u245_u24lambda_u244.select("td:nth-child(4)").text();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text(...)");
                String string6 = $this$parseBna_u24lambda_u245_u24lambda_u244.select("td:nth-child(5)").text();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"text(...)");
                fE = new FE(string2, string3, string4, string5, StringsKt.replace$default((String)string6, (String)",", (String)".", (boolean)false, (int)4, null), null, null, 96, null);
            }
            catch (Exception ex) {
                this.logger.error((Function0)new /* Unavailable Anonymous Inner Class!! */);
                fE = new FE("", "", "", "", "", null, null);
            }
            collection.add(fE);
        }
        List res2 = (List)destination$iv$iv;
        return res2;
    }

    public void generateIaru(int nr) {
        ResourceLoader resourceLoader = this.resourceLoader;
        if (resourceLoader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceLoader");
            resourceLoader = null;
        }
        File file = resourceLoader.getResource("classpath:data/iaru" + nr + ".txt").getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        String csv = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        CsvReader r2 = CsvReaderDslKt.csvReader((Function1)((Function1)generateIaru.r.1.INSTANCE));
        List rows = r2.readAll(csv);
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.logger.info(" -> " + it);
        }
        List bands = new ArrayList();
        IaruBand currentBand = null;
        Iterable $this$forEach$iv2 = rows;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String remark;
            List it = (List)element$iv;
            boolean bl = false;
            String i1 = (String)it.get(0);
            boolean isSeparator = StringsKt.startsWith$default((String)i1, (String)":", (boolean)false, (int)2, null);
            String i1_ = StringsKt.removePrefix((String)i1, (CharSequence)":");
            String[] stringArray = new String[]{"-"};
            List list = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)i1_, (String)" ", (String)"", (boolean)false, (int)4, null), (String)",", (String)".", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int start2 = (int)(Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)list.get(0)))).toString()) * (double)1000);
            int end = (int)(Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)list.get(1)))).toString()) * (double)1000);
            String text = remark = (String)it.get(3);
            if (isSeparator) {
                currentBand = new IaruBand(text, start2, end, text, (List)new ArrayList());
                bands.add(currentBand);
                continue;
            }
            IaruBand iaruBand = currentBand;
            Intrinsics.checkNotNull(iaruBand);
            iaruBand.getEntries().add(new IaruEntry(start2, end, (String)it.get(1), (String)it.get(2), text));
        }
        Unit o = Unit.INSTANCE;
        StringFormat $this$encodeToString$iv = (StringFormat)JsonKt.Json$default(null, (Function1)((Function1)generateIaru.json.1.INSTANCE), (int)1, null);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(IaruBand.Companion.serializer()), (Object)bands);
        String path = "..\\frontend\\src\\data\\Bandplan_Iaru" + nr + ".ts";
        File file2 = new File(path);
        this.logger.info("write cty json " + file2.getAbsolutePath());
        FilesKt.writeText$default((File)file2, (String)("import { IaruBand } from 'src/model/model';\r\nexport const bands_iaru" + nr + ": IaruBand[] =\r\n" + json2), null, (int)2, null);
    }
}

