/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.controller;

import com.example.ctrl891.controller.CatCommandBoolean;
import com.example.ctrl891.controller.CatCommandInt;
import com.example.ctrl891.controller.CatCommandString;
import com.example.ctrl891.controller.RestController;
import com.example.ctrl891.controller.WidthRequest;
import com.example.ctrl891.model.AdminRequest;
import com.example.ctrl891.model.CatCommand;
import com.example.ctrl891.model.CatCommandList;
import com.example.ctrl891.model.CatCommandValue;
import com.example.ctrl891.model.CatCommandsOPs;
import com.example.ctrl891.model.IntValue;
import com.example.ctrl891.model.MenuList;
import com.example.ctrl891.model.ValueType;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.ExportService;
import com.example.ctrl891.service.MessageRepository;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.SerialService;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

@CrossOrigin
@org.springframework.web.bind.annotation.RestController
@RequestMapping(value={"/ctrl"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ/\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0017\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u0012\u0010#\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017J\u001e\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010\"H\u0017J\u0012\u0010&\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010\u001aH\u0017J\u0012\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017J\u001c\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u00020+H\u0017J\u001c\u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u00020-H\u0017J\u001c\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u00020/H\u0017J\u001c\u00100\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u00020/H\u0017J\u001c\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u000202H\u0017J\u0012\u00103\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017J\u0012\u00104\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017J\u0012\u00105\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017J\u0010\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\u001bH\u0017J\u001c\u00108\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u001c\u00109\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u001c\u0010:\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u000202H\u0017J\u001c\u0010;\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\b\u0001\u0010*\u001a\u00020<H\u0017J\u0012\u0010=\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006>"}, d2={"Lcom/example/ctrl891/controller/RestController;", "", "messageRepository", "Lcom/example/ctrl891/service/MessageRepository;", "serialService", "Lcom/example/ctrl891/service/SerialService;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "catService", "Lcom/example/ctrl891/service/CatService;", "exportService", "Lcom/example/ctrl891/service/ExportService;", "(Lcom/example/ctrl891/service/MessageRepository;Lcom/example/ctrl891/service/SerialService;Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/service/CatService;Lcom/example/ctrl891/service/ExportService;)V", "getCatService", "()Lcom/example/ctrl891/service/CatService;", "getExportService", "()Lcom/example/ctrl891/service/ExportService;", "logger", "Lmu/KLogger;", "getMessageRepository", "()Lcom/example/ctrl891/service/MessageRepository;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "getSerialService", "()Lcom/example/ctrl891/service/SerialService;", "exportMenu", "Lreactor/core/publisher/Mono;", "Lcom/example/ctrl891/model/AdminRequest;", "changed_only", "", "include_title", "(Ljava/lang/Boolean;Ljava/lang/Boolean;)Lreactor/core/publisher/Mono;", "getEmployeeById", "cmd", "", "getPing", "importMenu", "name", "listMenu", "Lcom/example/ctrl891/model/MenuList;", "loadState", "post", "params", "Lcom/example/ctrl891/controller/CatCommandBoolean;", "postCommand", "Lcom/example/ctrl891/model/CatCommandValue;", "postInt", "Lcom/example/ctrl891/controller/CatCommandInt;", "postM", "postString", "Lcom/example/ctrl891/controller/CatCommandString;", "refresh", "refreshMenu", "saveState", "send", "m", "setClar", "setFreq", "setMode", "setWidth", "Lcom/example/ctrl891/controller/WidthRequest;", "startCat", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nRestController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestController.kt\ncom/example/ctrl891/controller/RestController\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,358:1\n526#2:359\n511#2,6:360\n*S KotlinDebug\n*F\n+ 1 RestController.kt\ncom/example/ctrl891/controller/RestController\n*L\n128#1:359\n128#1:360,6\n*E\n"})
public class RestController {
    @NotNull
    private final MessageRepository messageRepository;
    @NotNull
    private final SerialService serialService;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final CatService catService;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final KLogger logger;

    public RestController(@NotNull MessageRepository messageRepository, @NotNull SerialService serialService, @NotNull MessageService messageService, @NotNull CatService catService, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)messageRepository, (String)"messageRepository");
        Intrinsics.checkNotNullParameter((Object)serialService, (String)"serialService");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.messageRepository = messageRepository;
        this.serialService = serialService;
        this.messageService = messageService;
        this.catService = catService;
        this.exportService = exportService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public MessageRepository getMessageRepository() {
        return this.messageRepository;
    }

    @NotNull
    public SerialService getSerialService() {
        return this.serialService;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public CatService getCatService() {
        return this.catService;
    }

    @NotNull
    public ExportService getExportService() {
        return this.exportService;
    }

    @CrossOrigin
    @PostMapping(value={"/send"})
    @NotNull
    public String send(@NotNull AdminRequest m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.logger.info("send " + m);
        return "test";
    }

    @CrossOrigin
    @RequestMapping(path={"/command-b"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> post(@RequestBody @NotNull CatCommandBoolean params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CatCommandList c = CatCommandsOPs.INSTANCE.getCatCommand(params.getCmd());
        if (c != null && (c.getType() == ValueType.BOOL || c.getType() == ValueType.BOOL_INVERSE)) {
            boolean boo = params.getEnabled();
            boolean b = c.getType() == ValueType.BOOL_INVERSE ? !boo : boo;
            int bNum = b ? 1 : 0;
            String num = StringsKt.padStart((String)String.valueOf(bNum), (int)c.getDigits(), (char)'0');
            this.getCatService().sendUpdate(c, num);
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    /*
     * WARNING - void declaration
     */
    @CrossOrigin
    @RequestMapping(path={"/command-i"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> postInt(@RequestBody @NotNull CatCommandInt params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CatCommandList c = CatCommandsOPs.INSTANCE.getCatCommand(params.getCmd());
        if (c != null) {
            if (c.getType() == ValueType.INT) {
                int value = params.getValue();
                Object num = "";
                num = value < 0 && c.getDigits() == 3 ? "-" + StringsKt.padStart((String)String.valueOf(Math.abs(value)), (int)(c.getDigits() - 1), (char)'0') : (c.getMin() < 0 ? "+" + StringsKt.padStart((String)String.valueOf(value), (int)(c.getDigits() - 1), (char)'0') : StringsKt.padStart((String)String.valueOf(value), (int)c.getDigits(), (char)'0'));
                if (StringsKt.startsWith$default((String)c.getCode(), (String)"EX", (boolean)false, (int)2, null)) {
                    String code = StringsKt.removePrefix((String)c.getCode(), (CharSequence)"EX");
                    this.getCatService().sendMenuAndQuery(code, (String)num);
                } else {
                    this.getCatService().sendUpdate(c, (String)num);
                }
            } else if (c.getType() == ValueType.INT_MAPPED_INT) {
                void $this$filterTo$iv$iv;
                int i = params.getValue();
                Map map2 = c.getMapInt();
                Intrinsics.checkNotNull((Object)map2);
                Map $this$filter$iv = map2;
                boolean $i$f$filter = false;
                Map map3 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!(((Number)it.getValue()).intValue() == i)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map.Entry e = (Map.Entry)CollectionsKt.first((Iterable)destination$iv$iv.entrySet());
                String num = StringsKt.padStart((String)String.valueOf(((Number)e.getKey()).intValue()), (int)c.getDigits(), (char)'0');
                this.getCatService().sendUpdateAndQuery(c, num);
            } else if (c.getType() == ValueType.CUSTOM) {
                if (c.getHandler2() != null) {
                    IntValue cci = new IntValue(params.getCmd(), params.getValue());
                    String raw = (String)c.getHandler2().invoke((Object)cci);
                    this.getCatService().sendUpdate(c, raw);
                } else {
                    String num = String.valueOf(params.getValue());
                    this.getCatService().sendUpdate(c, num);
                }
            }
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @RequestMapping(path={"/command"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> postCommand(@RequestBody @NotNull CatCommandValue params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CatCommandList c = CatCommandsOPs.INSTANCE.getCatCommand(params.getCmd());
        if (c != null) {
            this.getCatService().sendQuery(c);
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @RequestMapping(path={"/command-s"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> postString(@RequestBody @NotNull CatCommandString params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CatCommandList c = CatCommandsOPs.INSTANCE.getCatCommand(params.getCmd());
        if (c != null) {
            if (c.getType() == ValueType.INT) {
                String num = StringsKt.padStart((String)params.getValue().toString(), (int)c.getDigits(), (char)'0');
                this.getCatService().sendUpdate(c, num);
            } else if (c.getType() == ValueType.CUSTOM) {
                if (c == CatCommandList.WIDTH) {
                    String num = params.getValue().toString();
                    this.getCatService().sendUpdate(c, num);
                    Thread.sleep(50L);
                    this.getCatService().sendQuery(CatCommandList.WIDTH);
                } else if (c == CatCommandList.IF_SHIFT) {
                    String num = params.getValue().toString();
                    this.getCatService().sendUpdate(c, num);
                    Thread.sleep(50L);
                    this.getCatService().sendQuery(CatCommandList.IF_SHIFT);
                }
            }
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @RequestMapping(path={"/command-m"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> postM(@RequestBody @NotNull CatCommandInt params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.getCatService().sendMenuSet(params.getCmd(), params.getValue());
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @RequestMapping(path={"/width"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> setWidth(@RequestBody @NotNull WidthRequest params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String narrS = params.getNarrowEnabled() ? "1" : "0";
        String widthS = StringsKt.padStart((String)String.valueOf(params.getWidth()), (int)2, (char)'0');
        String widthES = params.getWidthEnabled() ? "1" : "0";
        String cmd = CatCommandList.NARROW.getCode() + narrS + ";" + CatCommandList.WIDTH.getCode() + widthES + widthS;
        this.getCatService().sendUpdateMultiline(cmd);
        Thread.sleep(50L);
        this.getCatService().sendQuery(CatCommandList.WIDTH);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/send/{cmd}"})
    @Nullable
    public Mono<AdminRequest> getEmployeeById(@PathVariable @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        this.getCatService().sendPublic(cmd);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/start-cat"})
    @Nullable
    public Mono<AdminRequest> startCat() {
        this.getCatService().loadState();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/refresh"})
    @Nullable
    public Mono<AdminRequest> refresh() {
        this.getCatService().loadState();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/refresh-menu"})
    @Nullable
    public Mono<AdminRequest> refreshMenu() {
        this.getCatService().loadMenuState();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/export-menu"})
    @Nullable
    public Mono<AdminRequest> exportMenu(@RequestParam(value="changed_only") @Nullable Boolean changed_only, @RequestParam(value="include_title") @Nullable Boolean include_title) {
        this.getExportService().clear();
        this.getCatService().exportMenuState();
        Thread.sleep(1000L);
        Boolean bl = changed_only;
        Boolean bl2 = include_title;
        this.getExportService().export(bl != null ? bl : false, bl2 != null ? bl2 : false);
        this.logger.info("export completed");
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/import-menu"})
    @Nullable
    public Mono<AdminRequest> importMenu(@RequestParam(value="name") @Nullable String name) {
        ExportService exportService = this.getExportService();
        String string = name;
        if (string == null) {
            string = "";
        }
        exportService.import(string);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/list-menu"})
    @Nullable
    public Mono<MenuList> listMenu() {
        return Mono.just((Object)new MenuList(this.getExportService().list()));
    }

    @CrossOrigin
    @GetMapping(value={"/freq/{cmd}"})
    @Nullable
    public Mono<AdminRequest> setFreq(@PathVariable @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        CatService.setFreq$default((CatService)this.getCatService(), (int)Integer.parseInt(cmd), (boolean)false, (int)2, null);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/clar/{cmd}"})
    @Nullable
    public Mono<AdminRequest> setClar(@PathVariable @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        this.getCatService().setClar(Integer.parseInt(cmd));
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @PostMapping(value={"/mode"})
    @Nullable
    public Mono<AdminRequest> setMode(@RequestBody @NotNull CatCommandString params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @RequestMapping(path={"/ping"}, method={RequestMethod.GET}, produces={"application/json"})
    @Nullable
    public Mono<AdminRequest> getPing() {
        this.logger.info("get ping ");
        IntValue x1 = new IntValue("pong", 1);
        this.getMessageService().addCatMessage((CatCommand)x1);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/save-state"})
    @Nullable
    public Mono<AdminRequest> saveState() {
        this.logger.info("save state");
        this.getMessageRepository().saveState();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/load-state"})
    @Nullable
    public Mono<AdminRequest> loadState() {
        this.logger.info("load state");
        this.getMessageRepository().saveState();
        return Mono.just((Object)new AdminRequest("ok"));
    }
}

