/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.controller;

import com.example.ctrl891.controller.LogController;
import com.example.ctrl891.model.AdminRequest;
import com.example.ctrl891.model.LogEntry;
import com.example.ctrl891.model.Logbook;
import com.example.ctrl891.service.LogService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@CrossOrigin
@RestController
@RequestMapping(value={"/log"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0017J\u0012\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rH\u0017J\u001c\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\r2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u001c\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\r2\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/example/ctrl891/controller/LogController;", "", "logService", "Lcom/example/ctrl891/service/LogService;", "(Lcom/example/ctrl891/service/LogService;)V", "getLogService", "()Lcom/example/ctrl891/service/LogService;", "logger", "Lmu/KLogger;", "download", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/ByteArrayResource;", "listMenu", "Lreactor/core/publisher/Mono;", "Lcom/example/ctrl891/model/Logbook;", "settings", "Lcom/example/ctrl891/model/AdminRequest;", "params", "Lcom/example/ctrl891/model/LogEntry;", "ctrl891"})
public class LogController {
    @NotNull
    private final LogService logService;
    @NotNull
    private final KLogger logger;

    public LogController(@NotNull LogService logService) {
        Intrinsics.checkNotNullParameter((Object)logService, (String)"logService");
        this.logService = logService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public LogService getLogService() {
        return this.logService;
    }

    @CrossOrigin
    @PostMapping(value={"/add"})
    @Nullable
    public Mono<AdminRequest> settings(@RequestBody @NotNull LogEntry params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.logger.info("Logbook " + params);
        this.getLogService().writeLog(params);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @PostMapping(value={"/export"})
    @Nullable
    public Mono<AdminRequest> settings(@RequestBody @NotNull Logbook params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.logger.info("Logbook " + params);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/logbook"})
    @Nullable
    public Mono<Logbook> listMenu() {
        return Mono.just((Object)this.getLogService().readCurrentJson());
    }

    @CrossOrigin
    @GetMapping(value={"/download"}, produces={"application/octet-stream"})
    @NotNull
    public ResponseEntity<ByteArrayResource> download() {
        String text;
        String filename = "logbook.adi";
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Disposition", "attachment; filename=" + filename);
        header.add("Cache-Control", "no-cache, no-store, must-revalidate");
        header.add("Pragma", "no-cache");
        header.add("Expires", "0");
        String string = text = this.getLogService().getLogbookAdi();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        ByteArrayResource resource = new ByteArrayResource(bytes);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(header)).contentLength((long)bytes.length).body((Object)resource);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }
}

