/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.controller;

import com.example.ctrl891.controller.AudioController;
import com.example.ctrl891.model.AdminRequest;
import com.example.ctrl891.model.AudioFile;
import com.example.ctrl891.service.AudioService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@CrossOrigin
@RestController
@RequestMapping(value={"/audio"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0017J\u0012\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u0012\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u001c\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00112\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J\u0012\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u0012\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u0012\u0010\u001c\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u0012\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0011H\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001f\u001a\u00020 H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/example/ctrl891/controller/AudioController;", "", "audioService", "Lcom/example/ctrl891/service/AudioService;", "(Lcom/example/ctrl891/service/AudioService;)V", "getAudioService", "()Lcom/example/ctrl891/service/AudioService;", "flux", "Lreactor/core/publisher/Flux;", "", "logger", "Lmu/KLogger;", "mt", "Lorg/springframework/http/MediaType;", "getMt", "()Lorg/springframework/http/MediaType;", "listFiles", "Lreactor/core/publisher/Mono;", "", "Lcom/example/ctrl891/model/AudioFile;", "refresh", "Lcom/example/ctrl891/model/AdminRequest;", "start", "startFeedTest", "name", "", "startPlayback", "stop", "stopFeedTest", "stopPlayback", "stream", "response", "Lorg/springframework/http/server/reactive/ServerHttpResponse;", "ctrl891"})
public class AudioController {
    @NotNull
    private final AudioService audioService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final MediaType mt;
    @Autowired
    @Nullable
    private Flux<byte[]> flux;

    public AudioController(@NotNull AudioService audioService) {
        Intrinsics.checkNotNullParameter((Object)audioService, (String)"audioService");
        this.audioService = audioService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.mt = new MediaType("audio", "vnd.wave");
    }

    @NotNull
    public AudioService getAudioService() {
        return this.audioService;
    }

    @NotNull
    public MediaType getMt() {
        return this.mt;
    }

    @CrossOrigin
    @GetMapping(value={"/stream"}, produces={"audio/vnd.wave"})
    @NotNull
    public Flux<byte[]> stream(@NotNull ServerHttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Flux flux = this.flux;
        Intrinsics.checkNotNull((Object)flux);
        return flux;
    }

    @CrossOrigin
    @GetMapping(value={"/start-record"})
    @Nullable
    public Mono<AdminRequest> start() {
        this.logger.info("start");
        boolean started = this.getAudioService().startRecord();
        if (!started) {
            throw new Exception();
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/stop-record"})
    @Nullable
    public Mono<AdminRequest> stop() {
        this.logger.info("stop");
        this.getAudioService().stopRecord();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/start-play"})
    @Nullable
    public Mono<AdminRequest> startPlayback() {
        this.logger.info("start playback");
        boolean started = this.getAudioService().startPlayback();
        if (!started) {
            throw new Exception();
        }
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/stop-play"})
    @Nullable
    public Mono<AdminRequest> stopPlayback() {
        this.logger.info("stop");
        this.getAudioService().stopRecord();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/refresh"})
    @Nullable
    public Mono<AdminRequest> refresh() {
        this.logger.info("refresh");
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/start-play-wav/{name}"})
    @Nullable
    public Mono<AdminRequest> startFeedTest(@PathVariable @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.logger.info("start-play-wav " + name);
        this.getAudioService().startPlayWav(name);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/stop-play-wav"})
    @Nullable
    public Mono<AdminRequest> stopFeedTest() {
        this.logger.info("stop-play-wav");
        this.getAudioService().stopPlayWav();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/list-wav"})
    @NotNull
    public Mono<List<AudioFile>> listFiles() {
        this.logger.info("list-wav");
        Mono mono = Mono.just((Object)this.getAudioService().listWav());
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }
}

