/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.controller;

import com.example.ctrl891.controller.AdminController;
import com.example.ctrl891.model.AdminRequest;
import com.example.ctrl891.model.BatteryResetCmd;
import com.example.ctrl891.model.PortInfo;
import com.example.ctrl891.model.RigctlCmd;
import com.example.ctrl891.model.SettingsCmd;
import com.example.ctrl891.model.StateInfo;
import com.example.ctrl891.service.BatteryInfo;
import com.example.ctrl891.service.BatteryService;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.MessageRepository;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.RigctlService;
import com.example.ctrl891.service.SerialService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@CrossOrigin
@RestController
@RequestMapping(value={"/admin"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010\"H\u0017J\u001c\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010\"2\b\b\u0001\u0010%\u001a\u00020&H\u0017J\u0012\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\"H\u0017J\u0012\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\"H\u0017J\u0018\u0010*\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020,\u0018\u00010+\u0018\u00010\"H\u0017J\u001c\u0010-\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\"2\b\b\u0001\u0010%\u001a\u00020.H\u0017J\u001c\u0010/\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\"2\b\b\u0001\u0010%\u001a\u000200H\u0017J\u0012\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u000102\u0018\u00010\"H\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lcom/example/ctrl891/controller/AdminController;", "", "messageRepository", "Lcom/example/ctrl891/service/MessageRepository;", "serialService", "Lcom/example/ctrl891/service/SerialService;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "catService", "Lcom/example/ctrl891/service/CatService;", "coreService", "Lcom/example/ctrl891/service/CoreService;", "batteryService", "Lcom/example/ctrl891/service/BatteryService;", "rigctlService", "Lcom/example/ctrl891/service/RigctlService;", "(Lcom/example/ctrl891/service/MessageRepository;Lcom/example/ctrl891/service/SerialService;Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/service/CatService;Lcom/example/ctrl891/service/CoreService;Lcom/example/ctrl891/service/BatteryService;Lcom/example/ctrl891/service/RigctlService;)V", "getBatteryService", "()Lcom/example/ctrl891/service/BatteryService;", "getCatService", "()Lcom/example/ctrl891/service/CatService;", "getCoreService", "()Lcom/example/ctrl891/service/CoreService;", "logger", "Lmu/KLogger;", "getMessageRepository", "()Lcom/example/ctrl891/service/MessageRepository;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "getRigctlService", "()Lcom/example/ctrl891/service/RigctlService;", "getSerialService", "()Lcom/example/ctrl891/service/SerialService;", "battery", "Lreactor/core/publisher/Mono;", "Lcom/example/ctrl891/service/BatteryInfo;", "batteryReset", "params", "Lcom/example/ctrl891/model/BatteryResetCmd;", "connect", "Lcom/example/ctrl891/model/AdminRequest;", "disconnect", "refresh", "", "Lcom/example/ctrl891/model/PortInfo;", "rigctl", "Lcom/example/ctrl891/model/RigctlCmd;", "settings", "Lcom/example/ctrl891/model/SettingsCmd;", "state", "Lcom/example/ctrl891/model/StateInfo;", "ctrl891"})
public class AdminController {
    @NotNull
    private final MessageRepository messageRepository;
    @NotNull
    private final SerialService serialService;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final CatService catService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final BatteryService batteryService;
    @NotNull
    private final RigctlService rigctlService;
    @NotNull
    private final KLogger logger;

    public AdminController(@NotNull MessageRepository messageRepository, @NotNull SerialService serialService, @NotNull MessageService messageService, @NotNull CatService catService, @NotNull CoreService coreService, @NotNull BatteryService batteryService, @NotNull RigctlService rigctlService) {
        Intrinsics.checkNotNullParameter((Object)messageRepository, (String)"messageRepository");
        Intrinsics.checkNotNullParameter((Object)serialService, (String)"serialService");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)batteryService, (String)"batteryService");
        Intrinsics.checkNotNullParameter((Object)rigctlService, (String)"rigctlService");
        this.messageRepository = messageRepository;
        this.serialService = serialService;
        this.messageService = messageService;
        this.catService = catService;
        this.coreService = coreService;
        this.batteryService = batteryService;
        this.rigctlService = rigctlService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public MessageRepository getMessageRepository() {
        return this.messageRepository;
    }

    @NotNull
    public SerialService getSerialService() {
        return this.serialService;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public CatService getCatService() {
        return this.catService;
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @NotNull
    public BatteryService getBatteryService() {
        return this.batteryService;
    }

    @NotNull
    public RigctlService getRigctlService() {
        return this.rigctlService;
    }

    @CrossOrigin
    @GetMapping(value={"/state-info"})
    @Nullable
    public Mono<StateInfo> state() {
        StateInfo s = new StateInfo(this.getSerialService().getComPortName(), this.getSerialService().isConnected(), this.getCatService().isReconnect(), this.getCoreService().getBuildNr());
        return Mono.just((Object)s);
    }

    @CrossOrigin
    @GetMapping(value={"/serial-list"})
    @Nullable
    public Mono<List<PortInfo>> refresh() {
        return Mono.just((Object)this.getSerialService().listPorts());
    }

    @CrossOrigin
    @PostMapping(value={"/settings"})
    @Nullable
    public Mono<AdminRequest> settings(@RequestBody @NotNull SettingsCmd params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.logger.info("settings " + params);
        this.getCoreService().updateSettings(params);
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @PostMapping(value={"/serial-connect"})
    @Nullable
    public Mono<AdminRequest> connect() {
        this.logger.info("connect");
        this.getCatService().requestConnect();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @PostMapping(value={"/serial-disconnect"})
    @Nullable
    public Mono<AdminRequest> disconnect() {
        this.logger.info("disconnect");
        this.getCatService().disconnect();
        return Mono.just((Object)new AdminRequest("ok"));
    }

    @CrossOrigin
    @GetMapping(value={"/battery"})
    @Nullable
    public Mono<BatteryInfo> battery() {
        return Mono.just((Object)this.getBatteryService().getBatteryInfo());
    }

    @CrossOrigin
    @PostMapping(value={"/battery"})
    @Nullable
    public Mono<BatteryInfo> batteryReset(@RequestBody @NotNull BatteryResetCmd params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        BatteryService batteryService = this.getBatteryService();
        Integer n = params.getCapacityTotal();
        Intrinsics.checkNotNull((Object)n);
        return Mono.just((Object)batteryService.reset(n.intValue()));
    }

    @CrossOrigin
    @PostMapping(value={"/rigctl"})
    @Nullable
    public Mono<AdminRequest> rigctl(@RequestBody @NotNull RigctlCmd params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Boolean bl = params.getSyncEnabled();
        this.getRigctlService().setSyncEnabled(bl != null ? bl : false);
        this.getRigctlService().sendCurrentFreq();
        this.getRigctlService().sendState();
        return Mono.just((Object)new AdminRequest("ok"));
    }
}

