/*
 * Decompiled with CFR 0.152.
 */
package com.example.ctrl891.config;

import com.example.ctrl891.config.StartupApplicationListener;
import com.example.ctrl891.generator.GeneratorService;
import com.example.ctrl891.generator.MenuService;
import com.example.ctrl891.service.AudioService;
import com.example.ctrl891.service.BatteryService;
import com.example.ctrl891.service.CatService;
import com.example.ctrl891.service.CoreService;
import com.example.ctrl891.service.MessageService;
import com.example.ctrl891.service.SerialService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B]\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020\u0002H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u0004\u0018\u00010'8\u0012X\u0093D\u00a2\u0006\u0004\n\u0002\u0010(R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u0004\u0018\u00010'8\u0012X\u0093D\u00a2\u0006\u0004\n\u0002\u0010(R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006:"}, d2={"Lcom/example/ctrl891/config/StartupApplicationListener;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/context/event/ContextRefreshedEvent;", "coreService", "Lcom/example/ctrl891/service/CoreService;", "catService", "Lcom/example/ctrl891/service/CatService;", "serialService", "Lcom/example/ctrl891/service/SerialService;", "menuService", "Lcom/example/ctrl891/generator/MenuService;", "messageService", "Lcom/example/ctrl891/service/MessageService;", "batteryService", "Lcom/example/ctrl891/service/BatteryService;", "audioService", "Lcom/example/ctrl891/service/AudioService;", "configurableEnvironment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "ctx", "Lorg/springframework/context/ConfigurableApplicationContext;", "serverProperties", "Lorg/springframework/boot/autoconfigure/web/ServerProperties;", "generatorService", "Lcom/example/ctrl891/generator/GeneratorService;", "(Lcom/example/ctrl891/service/CoreService;Lcom/example/ctrl891/service/CatService;Lcom/example/ctrl891/service/SerialService;Lcom/example/ctrl891/generator/MenuService;Lcom/example/ctrl891/service/MessageService;Lcom/example/ctrl891/service/BatteryService;Lcom/example/ctrl891/service/AudioService;Lorg/springframework/core/env/ConfigurableEnvironment;Lorg/springframework/context/ConfigurableApplicationContext;Lorg/springframework/boot/autoconfigure/web/ServerProperties;Lcom/example/ctrl891/generator/GeneratorService;)V", "getAudioService", "()Lcom/example/ctrl891/service/AudioService;", "getBatteryService", "()Lcom/example/ctrl891/service/BatteryService;", "getCatService", "()Lcom/example/ctrl891/service/CatService;", "getConfigurableEnvironment", "()Lorg/springframework/core/env/ConfigurableEnvironment;", "getCoreService", "()Lcom/example/ctrl891/service/CoreService;", "getCtx", "()Lorg/springframework/context/ConfigurableApplicationContext;", "featureaudio", "", "Ljava/lang/Boolean;", "getGeneratorService", "()Lcom/example/ctrl891/generator/GeneratorService;", "logger", "Lmu/KLogger;", "getMenuService", "()Lcom/example/ctrl891/generator/MenuService;", "getMessageService", "()Lcom/example/ctrl891/service/MessageService;", "runDataGenerator", "getSerialService", "()Lcom/example/ctrl891/service/SerialService;", "getServerProperties", "()Lorg/springframework/boot/autoconfigure/web/ServerProperties;", "listPropertySources", "", "onApplicationEvent", "event", "ctrl891"})
@SourceDebugExtension(value={"SMAP\nStartupApplicationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupApplicationListener.kt\ncom/example/ctrl891/config/StartupApplicationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1855#2,2:105\n*S KotlinDebug\n*F\n+ 1 StartupApplicationListener.kt\ncom/example/ctrl891/config/StartupApplicationListener\n*L\n97#1:105,2\n*E\n"})
public class StartupApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CatService catService;
    @NotNull
    private final SerialService serialService;
    @NotNull
    private final MenuService menuService;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final BatteryService batteryService;
    @NotNull
    private final AudioService audioService;
    @NotNull
    private final ConfigurableEnvironment configurableEnvironment;
    @NotNull
    private final ConfigurableApplicationContext ctx;
    @NotNull
    private final ServerProperties serverProperties;
    @NotNull
    private final GeneratorService generatorService;
    @NotNull
    private final KLogger logger;
    @Value(value="${runDataGenerator:false}")
    @Nullable
    private final Boolean runDataGenerator;
    @Value(value="${feature.audio:false}")
    @Nullable
    private final Boolean featureaudio;

    public StartupApplicationListener(@NotNull CoreService coreService, @NotNull CatService catService, @NotNull SerialService serialService, @NotNull MenuService menuService, @NotNull MessageService messageService, @NotNull BatteryService batteryService, @NotNull AudioService audioService, @NotNull ConfigurableEnvironment configurableEnvironment, @NotNull ConfigurableApplicationContext ctx, @NotNull ServerProperties serverProperties, @NotNull GeneratorService generatorService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)catService, (String)"catService");
        Intrinsics.checkNotNullParameter((Object)serialService, (String)"serialService");
        Intrinsics.checkNotNullParameter((Object)menuService, (String)"menuService");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)batteryService, (String)"batteryService");
        Intrinsics.checkNotNullParameter((Object)audioService, (String)"audioService");
        Intrinsics.checkNotNullParameter((Object)configurableEnvironment, (String)"configurableEnvironment");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)serverProperties, (String)"serverProperties");
        Intrinsics.checkNotNullParameter((Object)generatorService, (String)"generatorService");
        this.coreService = coreService;
        this.catService = catService;
        this.serialService = serialService;
        this.menuService = menuService;
        this.messageService = messageService;
        this.batteryService = batteryService;
        this.audioService = audioService;
        this.configurableEnvironment = configurableEnvironment;
        this.ctx = ctx;
        this.serverProperties = serverProperties;
        this.generatorService = generatorService;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.runDataGenerator = false;
        this.featureaudio = false;
    }

    @NotNull
    public CoreService getCoreService() {
        return this.coreService;
    }

    @NotNull
    public CatService getCatService() {
        return this.catService;
    }

    @NotNull
    public SerialService getSerialService() {
        return this.serialService;
    }

    @NotNull
    public MenuService getMenuService() {
        return this.menuService;
    }

    @NotNull
    public MessageService getMessageService() {
        return this.messageService;
    }

    @NotNull
    public BatteryService getBatteryService() {
        return this.batteryService;
    }

    @NotNull
    public AudioService getAudioService() {
        return this.audioService;
    }

    @NotNull
    public ConfigurableEnvironment getConfigurableEnvironment() {
        return this.configurableEnvironment;
    }

    @NotNull
    public ConfigurableApplicationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    @NotNull
    public GeneratorService getGeneratorService() {
        return this.generatorService;
    }

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logger.info("Application init sequence start");
        this.logger.info("server.address=" + this.getServerProperties().getAddress());
        this.logger.info("server.port=" + this.getServerProperties().getPort());
        if (Intrinsics.areEqual((Object)this.runDataGenerator, (Object)true)) {
            this.getGeneratorService().generate();
            throw new RuntimeException();
        }
        this.getCoreService().init();
        if (Intrinsics.areEqual((Object)this.featureaudio, (Object)true)) {
            this.getAudioService().init();
            this.getAudioService().listDevices();
        }
        this.getSerialService().init();
        this.getMenuService().init();
        this.getMessageService().start();
        this.getCatService().start();
        this.getBatteryService().start();
        String hostname = this.getServerProperties().getAddress() == null ? "localhost" : this.getServerProperties().getAddress().getHostAddress();
        String port = this.getServerProperties().getPort() == null ? "8080" : this.getServerProperties().getPort();
        this.logger.info("=========================");
        this.logger.info("browser interface started: http://" + hostname + ":" + port + "/ui/");
        this.logger.info("Application init sequence end");
    }

    public void listPropertySources() {
        MutablePropertySources mutablePropertySources = this.getConfigurableEnvironment().getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
        Iterable $this$forEach$iv = (Iterable)mutablePropertySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertySource ps = (PropertySource)element$iv;
            boolean bl = false;
            this.logger.info("PropertySource: " + ps);
        }
    }
}

